/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache;

import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.CacheStats;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.cache.query.parser.QueryParserCache;
import org.elasticsearch.index.settings.IndexSettings;

public class IndexCache
extends AbstractIndexComponent
implements CloseableComponent,
ClusterStateListener {
    private final FilterCache filterCache;
    private final FieldDataCache fieldDataCache;
    private final QueryParserCache queryParserCache;
    private final IdCache idCache;
    private final BloomCache bloomCache;
    private ClusterService clusterService;

    @Inject
    public IndexCache(Index index, @IndexSettings Settings indexSettings, FilterCache filterCache, FieldDataCache fieldDataCache, QueryParserCache queryParserCache, IdCache idCache, BloomCache bloomCache) {
        super(index, indexSettings);
        this.filterCache = filterCache;
        this.fieldDataCache = fieldDataCache;
        this.queryParserCache = queryParserCache;
        this.idCache = idCache;
        this.bloomCache = bloomCache;
    }

    @Inject(optional=true)
    public void setClusterService(@Nullable ClusterService clusterService) {
        this.clusterService = clusterService;
        if (clusterService != null) {
            clusterService.add(this);
        }
    }

    public CacheStats stats() {
        return new CacheStats(this.fieldDataCache.evictions(), this.filterCache.evictions(), this.filterCache.memEvictions(), this.fieldDataCache.sizeInBytes(), this.filterCache.sizeInBytes(), this.filterCache.count(), this.bloomCache.sizeInBytes());
    }

    public FilterCache filter() {
        return this.filterCache;
    }

    public FieldDataCache fieldData() {
        return this.fieldDataCache;
    }

    public IdCache idCache() {
        return this.idCache;
    }

    public BloomCache bloomCache() {
        return this.bloomCache;
    }

    public QueryParserCache queryParserCache() {
        return this.queryParserCache;
    }

    @Override
    public void close() throws ElasticSearchException {
        this.filterCache.close();
        this.fieldDataCache.close();
        this.idCache.close();
        this.queryParserCache.close();
        this.bloomCache.close();
        if (this.clusterService != null) {
            this.clusterService.remove(this);
        }
    }

    public void clear(IndexReader reader) {
        this.filterCache.clear(reader);
        this.fieldDataCache.clear(reader);
        this.idCache.clear(reader);
        this.bloomCache.clear(reader);
    }

    public void clear() {
        this.filterCache.clear();
        this.fieldDataCache.clear();
        this.idCache.clear();
        this.queryParserCache.clear();
        this.bloomCache.clear();
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.metaDataChanged()) {
            this.queryParserCache.clear();
        }
    }
}

