/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;

public class BoolQueryBuilder
extends BaseQueryBuilder {
    private ArrayList<Clause> clauses = new ArrayList();
    private float boost = -1.0f;
    private Boolean disableCoord;
    private int minimumNumberShouldMatch = -1;

    public BoolQueryBuilder must(XContentQueryBuilder queryBuilder) {
        this.clauses.add(new Clause(queryBuilder, BooleanClause.Occur.MUST));
        return this;
    }

    public BoolQueryBuilder mustNot(XContentQueryBuilder queryBuilder) {
        this.clauses.add(new Clause(queryBuilder, BooleanClause.Occur.MUST_NOT));
        return this;
    }

    public BoolQueryBuilder should(XContentQueryBuilder queryBuilder) {
        this.clauses.add(new Clause(queryBuilder, BooleanClause.Occur.SHOULD));
        return this;
    }

    public BoolQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public BoolQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public BoolQueryBuilder minimumNumberShouldMatch(int minimumNumberShouldMatch) {
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        return this;
    }

    public List<Clause> clauses() {
        return this.clauses;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("bool");
        for (Clause clause : this.clauses) {
            if (clause.occur == BooleanClause.Occur.MUST) {
                builder.field("must");
                clause.queryBuilder.toXContent(builder, params);
                continue;
            }
            if (clause.occur == BooleanClause.Occur.MUST_NOT) {
                builder.field("must_not");
                clause.queryBuilder.toXContent(builder, params);
                continue;
            }
            if (clause.occur != BooleanClause.Occur.SHOULD) continue;
            builder.field("should");
            clause.queryBuilder.toXContent(builder, params);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.disableCoord != null) {
            builder.field("disable_coord", (Object)this.disableCoord);
        }
        if (this.minimumNumberShouldMatch != -1) {
            builder.field("minimum_number_should_match", this.minimumNumberShouldMatch);
        }
        builder.endObject();
    }

    private static class Clause {
        final XContentQueryBuilder queryBuilder;
        final BooleanClause.Occur occur;

        private Clause(XContentQueryBuilder queryBuilder, BooleanClause.Occur occur) {
            this.queryBuilder = queryBuilder;
            this.occur = occur;
        }
    }
}

