/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilderException;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentSpanQueryBuilder;

public class SpanNearQueryBuilder
extends BaseQueryBuilder
implements XContentSpanQueryBuilder {
    private ArrayList<XContentSpanQueryBuilder> clauses = new ArrayList();
    private int slop = -1;
    private Boolean inOrder;
    private Boolean collectPayloads;
    private float boost = -1.0f;

    public SpanNearQueryBuilder clause(XContentSpanQueryBuilder clause) {
        this.clauses.add(clause);
        return this;
    }

    public SpanNearQueryBuilder slop(int slop) {
        this.slop = slop;
        return this;
    }

    public SpanNearQueryBuilder inOrder(boolean inOrder) {
        this.inOrder = inOrder;
        return this;
    }

    public SpanNearQueryBuilder collectPayloads(boolean collectPayloads) {
        this.collectPayloads = collectPayloads;
        return this;
    }

    public SpanNearQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.clauses.isEmpty()) {
            throw new QueryBuilderException("Must have at least one clause when building a spanNear query");
        }
        if (this.slop == -1) {
            throw new QueryBuilderException("Must set the slop when building a spanNear query");
        }
        builder.startObject("span_near");
        builder.startArray("clauses");
        for (XContentSpanQueryBuilder clause : this.clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("slop", this.slop);
        if (this.inOrder != null) {
            builder.field("in_order", (Object)this.inOrder);
        }
        if (this.collectPayloads != null) {
            builder.field("collect_payloads", (Object)this.collectPayloads);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

