/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.mvel.MvelScriptEngineService;
import org.elasticsearch.search.lookup.SearchLookup;

public class ScriptService
extends AbstractComponent {
    private final String defaultLang;
    private final ImmutableMap<String, ScriptEngineService> scriptEngines;
    private final ConcurrentMap<String, CompiledScript> staticCache = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<String, CompiledScript> cache = new MapMaker().softValues().makeMap();

    public ScriptService(Settings settings) {
        this(settings, new Environment(), (Set<ScriptEngineService>)((Object)((ImmutableSet.Builder)ImmutableSet.builder().add(new MvelScriptEngineService(settings))).build()));
    }

    @Inject
    public ScriptService(Settings settings, Environment env, Set<ScriptEngineService> scriptEngines) {
        super(settings);
        this.defaultLang = this.componentSettings.get("default_lang", "mvel");
        ImmutableMap.Builder<String, ScriptEngineService> builder = ImmutableMap.builder();
        for (ScriptEngineService scriptEngine : scriptEngines) {
            for (String type : scriptEngine.types()) {
                builder.put(type, scriptEngine);
            }
        }
        this.scriptEngines = builder.build();
        File scriptsFile = new File(env.configFile(), "scripts");
        if (scriptsFile.exists()) {
            this.processScriptsDirectory("", scriptsFile);
        }
    }

    private void processScriptsDirectory(String prefix, File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.processScriptsDirectory(prefix + file.getName() + "_", file);
                continue;
            }
            int extIndex = file.getName().lastIndexOf(46);
            if (extIndex == -1) continue;
            String ext = file.getName().substring(extIndex + 1);
            String scriptName = prefix + file.getName().substring(0, extIndex);
            boolean found = false;
            for (ScriptEngineService engineService : this.scriptEngines.values()) {
                for (String s : engineService.extensions()) {
                    if (!s.equals(ext)) continue;
                    found = true;
                    try {
                        String script = Streams.copyToString(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        this.staticCache.put(scriptName, new CompiledScript(engineService.types()[0], engineService.compile(script)));
                    }
                    catch (Exception e) {
                        this.logger.warn("failed to load/compile script [{}]", e, scriptName);
                    }
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) continue;
            this.logger.warn("no script engine found for [{}]", ext);
        }
    }

    public void close() {
        for (ScriptEngineService engineService : this.scriptEngines.values()) {
            engineService.close();
        }
    }

    public CompiledScript compile(String script) {
        return this.compile(this.defaultLang, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript compile(String lang, String script) {
        CompiledScript compiled = (CompiledScript)this.staticCache.get(script);
        if (compiled != null) {
            return compiled;
        }
        compiled = (CompiledScript)this.cache.get(script);
        if (compiled != null) {
            return compiled;
        }
        if (lang == null) {
            lang = this.defaultLang;
        }
        ConcurrentMap<String, CompiledScript> concurrentMap = this.cache;
        synchronized (concurrentMap) {
            compiled = (CompiledScript)this.cache.get(script);
            if (compiled != null) {
                return compiled;
            }
            ScriptEngineService service = this.scriptEngines.get(lang);
            if (service == null) {
                throw new ElasticSearchIllegalArgumentException("script_lang not supported [" + lang + "]");
            }
            compiled = new CompiledScript(lang, service.compile(script));
            this.cache.put(script, compiled);
        }
        return compiled;
    }

    public ExecutableScript executable(String lang, String script, Map vars) {
        return this.executable(this.compile(lang, script), vars);
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map vars) {
        return this.scriptEngines.get(compiledScript.lang()).executable(compiledScript.compiled(), vars);
    }

    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        return this.scriptEngines.get(compiledScript.lang()).search(compiledScript.compiled(), lookup, vars);
    }

    public SearchScript search(SearchLookup lookup, String lang, String script, @Nullable Map<String, Object> vars) {
        return this.search(this.compile(lang, script), lookup, vars);
    }

    public SearchScript search(MapperService mapperService, FieldDataCache fieldDataCache, String lang, String script, @Nullable Map<String, Object> vars) {
        return this.search(this.compile(lang, script), new SearchLookup(mapperService, fieldDataCache), vars);
    }

    public Object execute(CompiledScript compiledScript, Map vars) {
        return this.scriptEngines.get(compiledScript.lang()).execute(compiledScript.compiled(), vars);
    }

    public void clear() {
        this.cache.clear();
    }
}

