/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.query.QuerySearchResult;

public class ScrollQuerySearchResult
implements Streamable {
    private QuerySearchResult queryResult;
    private SearchShardTarget shardTarget;

    public ScrollQuerySearchResult() {
    }

    public ScrollQuerySearchResult(QuerySearchResult queryResult, SearchShardTarget shardTarget) {
        this.queryResult = queryResult;
        this.shardTarget = shardTarget;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardTarget = SearchShardTarget.readSearchShardTarget(in);
        this.queryResult = QuerySearchResult.readQuerySearchResult(in);
        this.queryResult.shardTarget(this.shardTarget);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardTarget.writeTo(out);
        this.queryResult.writeTo(out);
    }
}

