/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import java.io.NotSerializableException;
import org.elasticsearch.common.io.ThrowableObjectOutputStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.local.LocalTransport;
import org.elasticsearch.transport.support.TransportStreams;

public class LocalTransportChannel
implements TransportChannel {
    private final LocalTransport sourceTransport;
    private final LocalTransport targetTransport;
    private final String action;
    private final long requestId;

    public LocalTransportChannel(LocalTransport sourceTransport, LocalTransport targetTransport, String action, long requestId) {
        this.sourceTransport = sourceTransport;
        this.targetTransport = targetTransport;
        this.action = action;
        this.requestId = requestId;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public void sendResponse(Streamable message) throws IOException {
        this.sendResponse(message, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(Streamable message, TransportResponseOptions options) throws IOException {
        HandlesStreamOutput stream = CachedStreamOutput.cachedHandlesBytes();
        stream.writeLong(this.requestId);
        byte status = 0;
        status = TransportStreams.statusSetResponse(status);
        stream.writeByte(status);
        message.writeTo(stream);
        final byte[] data = ((BytesStreamOutput)stream.wrappedOut()).copiedByteArray();
        this.targetTransport.threadPool().cached().execute(new Runnable(){

            @Override
            public void run() {
                LocalTransportChannel.this.targetTransport.messageReceived(data, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, null);
            }
        });
    }

    @Override
    public void sendResponse(Throwable error) throws IOException {
        BytesStreamOutput stream;
        try {
            stream = CachedStreamOutput.cachedBytes();
            this.writeResponseExceptionHeader(stream);
            RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddress(), this.action, error);
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        catch (NotSerializableException e) {
            stream = CachedStreamOutput.cachedBytes();
            this.writeResponseExceptionHeader(stream);
            RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddress(), this.action, new NotSerializableTransportException(error));
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        final byte[] data = stream.copiedByteArray();
        this.targetTransport.threadPool().cached().execute(new Runnable(){

            @Override
            public void run() {
                LocalTransportChannel.this.targetTransport.messageReceived(data, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, null);
            }
        });
    }

    private void writeResponseExceptionHeader(BytesStreamOutput stream) throws IOException {
        stream.writeLong(this.requestId);
        byte status = 0;
        status = TransportStreams.statusSetResponse(status);
        status = TransportStreams.statusSetError(status);
        stream.writeByte(status);
    }
}

