/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.aries.transaction.jdbc.internal.NLS;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionWrapper
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.apache.aries.transaction.jdbc");
    private Connection connection;
    private boolean closed;
    private boolean enlisted;

    public ConnectionWrapper(Connection connection, boolean enlisted) {
        this.enlisted = enlisted;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            try {
                if (!this.enlisted) {
                    this.connection.close();
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.enlisted) {
            throw new SQLException(NLS.MESSAGES.getMessage("datasource.enlised.commit", new Object[0]));
        }
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.enlisted) {
            throw new SQLException(NLS.MESSAGES.getMessage("datasource.enlised.rollback", new Object[0]));
        }
        this.connection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.enlisted) {
            throw new SQLException(NLS.MESSAGES.getMessage("datasource.enlised.rollback", new Object[0]));
        }
        this.connection.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.enlisted) {
            throw new SQLException(NLS.MESSAGES.getMessage("datasource.enlised.savepoint", new Object[0]));
        }
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.enlisted) {
            throw new SQLException(NLS.MESSAGES.getMessage("datasource.enlised.savepoint", new Object[0]));
        }
        return this.connection.setSavepoint(name);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Method method = this.getMethod("createArrayOf", String.class, Object[].class);
        return (Array)this.invokeByReflection(method, typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        Method method = this.getMethod("createBlob", new Class[0]);
        return (Blob)this.invokeByReflection(method, new Object[0]);
    }

    @Override
    public Clob createClob() throws SQLException {
        Method method = this.getMethod("createClob", new Class[0]);
        return (Clob)this.invokeByReflection(method, new Object[0]);
    }

    @Override
    @IgnoreJRERequirement
    public NClob createNClob() throws SQLException {
        Method method = this.getMethod("createNClob", new Class[0]);
        return (NClob)this.invokeByReflection(method, new Object[0]);
    }

    @Override
    @IgnoreJRERequirement
    public SQLXML createSQLXML() throws SQLException {
        Method method = this.getMethod("createSQLXML", new Class[0]);
        return (SQLXML)this.invokeByReflection(method, new Object[0]);
    }

    @Override
    public Statement createStatement() throws SQLException {
        Method method = this.getMethod("createStatement", new Class[0]);
        return (Statement)this.invokeByReflection(method, new Object[0]);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Method method = this.getMethod("createStatement", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        return (Statement)this.invokeByReflection(method, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Method method = this.getMethod("createStatement", Integer.TYPE, Integer.TYPE);
        return (Statement)this.invokeByReflection(method, resultSetType, resultSetConcurrency);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Method method = this.getMethod("createStruct", String.class, Object[].class);
        return (Struct)this.invokeByReflection(method, typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Method method = this.getMethod("getClientInfo", new Class[0]);
        Properties properties = (Properties)this.invokeByReflection(method, new Object[0]);
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        Method method = this.getMethod("getClientInfo", String.class);
        return (String)this.invokeByReflection(method, name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        Method method = this.getMethod("isValid", Integer.TYPE);
        Boolean answer = (Boolean)this.invokeByReflection(method, timeout);
        if (answer != null) {
            return answer;
        }
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInstance(this.connection)) {
            return true;
        }
        Method method = this.getMethod("isWrapperFor", Class.class);
        Boolean answer = (Boolean)this.invokeByReflection(method, iface);
        if (answer != null) {
            return answer;
        }
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    @IgnoreJRERequirement
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Method method = this.getMethod("setClientInfo", Properties.class);
        try {
            this.invokeByReflection(method, properties);
        }
        catch (SQLException e) {
            logger.debug(e.toString());
            throw new SQLClientInfoException(e.toString(), null);
        }
    }

    @Override
    @IgnoreJRERequirement
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Method method = this.getMethod("setClientInfo", String.class, String.class);
        try {
            this.invokeByReflection(method, name, value);
        }
        catch (SQLException e) {
            logger.debug(e.toString());
            throw new SQLClientInfoException(e.toString(), null);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.connection)) {
            return (T)this.connection;
        }
        Method method = this.getMethod("unwrap", Class.class);
        return (T)this.invokeByReflection(method, iface);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        Method method = this.getMethod("setSchema", String.class);
        this.invokeByReflection(method, schema);
    }

    @Override
    public String getSchema() throws SQLException {
        Method method = this.getMethod("getSchema", new Class[0]);
        return (String)this.invokeByReflection(method, new Object[0]);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        Method method = this.getMethod("abort", Executor.class);
        this.invokeByReflection(method, executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        Method method = this.getMethod("setNetworkTimeout", Integer.TYPE);
        this.invokeByReflection(method, executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        Method method = this.getMethod("getNetworkTimeout", new Class[0]);
        return (Integer)this.invokeByReflection(method, new Object[0]);
    }

    private Method getMethod(String methodName, Class<?> ... paramTypes) {
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, paramTypes);
        }
        catch (SecurityException e) {
            logger.debug(e.toString());
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.toString());
        }
        return method;
    }

    private Object invokeByReflection(Method method, Object ... params) throws SQLException {
        Object answer = null;
        try {
            Method m = this.connection.getClass().getMethod(method.getName(), method.getParameterTypes());
            answer = m.invoke((Object)this.connection, params);
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.toString());
        }
        catch (IllegalArgumentException e) {
            logger.debug(e.toString());
        }
        catch (IllegalAccessException e) {
            logger.debug(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getCause().toString());
        }
        return answer;
    }
}

