/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.io.IOException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericResourceManager.class);
    private String resourceName;
    private TransactionManager transactionManager;
    private XADataSource dataSource;

    public GenericResourceManager() {
    }

    public GenericResourceManager(String resourceName, TransactionManager transactionManager, XADataSource dataSource) {
        this.resourceName = resourceName;
        this.transactionManager = transactionManager;
        this.dataSource = dataSource;
    }

    public void recoverResource() {
        try {
            if (!Recovery.recover(this)) {
                LOGGER.info("Resource manager is unrecoverable");
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.info("Resource manager is unrecoverable due to missing classes: " + e);
        }
        catch (Throwable e) {
            LOGGER.warn("Error while recovering resource manager", e);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public XADataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(XADataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static class ConnectionAndWrapperNamedXAResource
    extends WrapperNamedXAResource {
        final XAConnection connection;

        public ConnectionAndWrapperNamedXAResource(XAResource xaResource, String name, XAConnection connection) {
            super(xaResource, name);
            this.connection = connection;
        }
    }

    public static class Recovery {
        public static boolean isRecoverable(GenericResourceManager rm) {
            return rm.getTransactionManager() instanceof RecoverableTransactionManager && rm.getResourceName() != null && !"".equals(rm.getResourceName());
        }

        public static boolean recover(final GenericResourceManager rm) throws IOException {
            if (Recovery.isRecoverable(rm)) {
                final XADataSource dataSource = rm.getDataSource();
                RecoverableTransactionManager rtxManager = (RecoverableTransactionManager)rm.getTransactionManager();
                rtxManager.registerNamedXAResourceFactory(new NamedXAResourceFactory(){

                    public String getName() {
                        return rm.getResourceName();
                    }

                    public NamedXAResource getNamedXAResource() throws SystemException {
                        try {
                            XAConnection connection = dataSource.getXAConnection();
                            LOGGER.debug("new namedXAResource's connection: " + connection);
                            return new ConnectionAndWrapperNamedXAResource(connection.getXAResource(), this.getName(), connection);
                        }
                        catch (Exception e) {
                            SystemException se = new SystemException("Failed to create ConnectionAndWrapperNamedXAResource, " + e.getLocalizedMessage());
                            se.initCause((Throwable)e);
                            LOGGER.error(se.getLocalizedMessage(), (Throwable)se);
                            throw se;
                        }
                    }

                    public void returnNamedXAResource(NamedXAResource namedXaResource) {
                        if (namedXaResource instanceof ConnectionAndWrapperNamedXAResource) {
                            try {
                                LOGGER.debug("closing returned namedXAResource's connection: " + ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection);
                                ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection.close();
                            }
                            catch (Exception ignored) {
                                LOGGER.debug("failed to close returned namedXAResource: " + namedXaResource, (Throwable)ignored);
                            }
                        }
                    }
                });
                return true;
            }
            return false;
        }
    }
}

