/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseManagedServiceFactory<T>
implements ManagedServiceFactory {
    public static final long DEFAULT_TIMEOUT_BEFORE_INTERRUPT = 30000L;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final BundleContext context;
    private final String name;
    private final long timeoutBeforeInterrupt;
    private final AtomicBoolean destroyed;
    private final ExecutorService executor;
    private final Map<String, Pair<T, ServiceRegistration>> services;

    public BaseManagedServiceFactory(BundleContext context, String name) {
        this(context, name, 30000L);
    }

    public BaseManagedServiceFactory(BundleContext context, String name, long timeoutBeforeInterrupt) {
        this.context = context;
        this.name = name;
        this.timeoutBeforeInterrupt = timeoutBeforeInterrupt;
        this.destroyed = new AtomicBoolean(false);
        this.executor = Executors.newSingleThreadExecutor();
        this.services = new ConcurrentHashMap<String, Pair<T, ServiceRegistration>>();
    }

    public String getName() {
        return this.name;
    }

    public void updated(final String pid, final Dictionary properties) throws ConfigurationException {
        if (this.destroyed.get()) {
            return;
        }
        this.checkConfiguration(pid, properties);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseManagedServiceFactory.this.internalUpdate(pid, properties);
                }
                catch (Throwable t) {
                    BaseManagedServiceFactory.this.LOGGER.warn("Error destroying service for ManagedServiceFactory " + BaseManagedServiceFactory.this.getName(), t);
                }
            }
        });
    }

    public void deleted(final String pid) {
        if (this.destroyed.get()) {
            return;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseManagedServiceFactory.this.internalDelete(pid);
                }
                catch (Throwable throwable) {
                    BaseManagedServiceFactory.this.LOGGER.warn("Error destroying service for ManagedServiceFactory " + BaseManagedServiceFactory.this.getName(), throwable);
                }
            }
        });
    }

    protected void checkConfiguration(String pid, Dictionary properties) throws ConfigurationException {
    }

    protected abstract T doCreate(Dictionary var1) throws Exception;

    protected T doUpdate(T t, Dictionary properties) throws Exception {
        this.doDestroy(t);
        return this.doCreate(properties);
    }

    protected abstract void doDestroy(T var1) throws Exception;

    protected abstract String[] getExposedClasses(T var1);

    private void internalUpdate(String pid, Dictionary properties) {
        Pair<T, ServiceRegistration> pair = this.services.get(pid);
        if (pair != null) {
            try {
                T t = this.doUpdate(pair.getFirst(), properties);
                pair.setFirst(t);
                pair.getSecond().setProperties(properties);
            }
            catch (Throwable throwable) {
                this.internalDelete(pid);
                this.LOGGER.warn("Error updating service for ManagedServiceFactory " + this.getName(), throwable);
            }
        } else {
            if (this.destroyed.get()) {
                return;
            }
            try {
                T t = this.doCreate(properties);
                try {
                    if (this.destroyed.get()) {
                        throw new IllegalStateException("ManagedServiceFactory has been destroyed");
                    }
                    ServiceRegistration registration = this.context.registerService(this.getExposedClasses(t), t, properties);
                    this.services.put(pid, new Pair<T, ServiceRegistration>(t, registration));
                }
                catch (Throwable throwable1) {
                    try {
                        this.doDestroy(t);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable1;
                }
            }
            catch (Throwable throwable) {
                this.LOGGER.warn("Error creating service for ManagedServiceFactory " + this.getName(), throwable);
            }
        }
    }

    private void internalDelete(String pid) {
        Pair<T, ServiceRegistration> pair = this.services.remove(pid);
        if (pair != null) {
            try {
                pair.getSecond().unregister();
            }
            catch (Throwable t) {
                this.LOGGER.info("Error unregistering service", t);
            }
            try {
                this.doDestroy(pair.getFirst());
            }
            catch (Throwable t) {
                this.LOGGER.info("Error destroying service", t);
            }
        }
    }

    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(this.timeoutBeforeInterrupt, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Shutdown interrupted");
            }
            if (!this.executor.isTerminated()) {
                this.executor.shutdownNow();
                try {
                    this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Shutdown interrupted");
                }
            }
            while (!this.services.isEmpty()) {
                String pid = this.services.keySet().iterator().next();
                this.internalDelete(pid);
            }
        }
    }

    static class Pair<U, V> {
        private U first;
        private V second;

        public Pair(U first, V second) {
            this.first = first;
            this.second = second;
        }

        public U getFirst() {
            return this.first;
        }

        public V getSecond() {
            return this.second;
        }

        public void setFirst(U first) {
            this.first = first;
        }

        public void setSecond(V second) {
            this.second = second;
        }
    }
}

