/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.model.RouteDefinition;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelControllerImpl
implements CamelController {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelControllerImpl.class);
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public List<CamelContext> getCamelContexts() {
        ArrayList<CamelContext> camelContexts = new ArrayList<CamelContext>();
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences(CamelContext.class.getName(), null);
            if (references != null) {
                for (ServiceReference reference : references) {
                    CamelContext camelContext;
                    if (reference == null || (camelContext = (CamelContext)this.bundleContext.getService(reference)) == null) continue;
                    camelContexts.add(camelContext);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot retrieve the list of Camel contexts.", (Throwable)e);
        }
        return camelContexts;
    }

    @Override
    public CamelContext getCamelContext(String name) {
        for (CamelContext camelContext : this.getCamelContexts()) {
            if (!camelContext.getName().equals(name)) continue;
            return camelContext;
        }
        return null;
    }

    @Override
    public List<Route> getRoutes(String camelContextName) {
        if (camelContextName != null) {
            CamelContext context = this.getCamelContext(camelContextName);
            if (context != null) {
                return context.getRoutes();
            }
        } else {
            ArrayList<Route> routes = new ArrayList<Route>();
            List<CamelContext> camelContexts = this.getCamelContexts();
            for (CamelContext camelContext : camelContexts) {
                for (Route route : camelContext.getRoutes()) {
                    routes.add(route);
                }
            }
            return routes;
        }
        return null;
    }

    @Override
    public List<Route> getRoutes(String camelContextName, String filter) {
        ArrayList<Route> routes;
        block6: {
            block5: {
                routes = null;
                if (camelContextName == null) break block5;
                CamelContext context = this.getCamelContext(camelContextName);
                if (context == null) break block6;
                for (Route route : context.getRoutes()) {
                    if (routes == null) {
                        routes = new ArrayList<Route>();
                    }
                    if (!route.getId().matches(filter)) continue;
                    routes.add(route);
                }
                break block6;
            }
            List<CamelContext> camelContexts = this.getCamelContexts();
            for (CamelContext camelContext : camelContexts) {
                for (Route route : camelContext.getRoutes()) {
                    if (routes == null) {
                        routes = new ArrayList();
                    }
                    if (!route.getId().matches(filter)) continue;
                    routes.add(route);
                }
            }
        }
        return routes;
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions(String camelContextName) {
        if (camelContextName != null) {
            CamelContext context = this.getCamelContext(camelContextName);
            if (context != null) {
                return context.getRouteDefinitions();
            }
        } else {
            ArrayList<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
            List<CamelContext> camelContexts = this.getCamelContexts();
            for (CamelContext camelContext : camelContexts) {
                for (RouteDefinition routeDefinition : camelContext.getRouteDefinitions()) {
                    routeDefinitions.add(routeDefinition);
                }
            }
            return routeDefinitions;
        }
        return null;
    }

    @Override
    public Route getRoute(String routeId, String camelContextName) {
        List<Route> routes = this.getRoutes(camelContextName);
        for (Route route : routes) {
            if (!route.getId().equals(routeId)) continue;
            return route;
        }
        return null;
    }

    @Override
    public RouteDefinition getRouteDefinition(String routeId, String camelContextName) {
        CamelContext context = this.getCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        return context.getRouteDefinition(routeId);
    }
}

