/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.completers.AllFeatureCompleter;
import org.apache.karaf.features.command.completers.FeatureRepositoryCompleter;
import org.fusesource.fabric.commands.support.BundleCompleter;
import org.fusesource.fabric.commands.support.FeaturesCompleterDelegate;
import org.fusesource.fabric.commands.support.FeaturesRepositoryCompleterDelegate;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private Runnable featuresServiceSupport;
    private Runnable featureBundleLocationSupport;

    public void start(BundleContext context) throws Exception {
        try {
            this.featuresServiceSupport = new FeaturesServiceSupport(context);
            this.featureBundleLocationSupport = new FeatureBundleLocationSupport(context);
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.warn("Feature service is not present, Feature / Repository completion will be disabled");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.featuresServiceSupport != null) {
            this.featuresServiceSupport.run();
        }
        if (this.featureBundleLocationSupport != null) {
            this.featureBundleLocationSupport.run();
        }
    }

    private static class FeatureBundleLocationSupport
    implements Callable<Set<String>>,
    Runnable {
        private BundleContext context;
        private ServiceRegistration registration;
        private ServiceTracker serviceTracker;
        private FeaturesService featuresService;

        private FeatureBundleLocationSupport(BundleContext context) {
            this.context = context;
            this.featuresService = this.getFeaturesService();
            BundleCompleter.BUNDLE_LOCATION_SET = this;
        }

        @Override
        public void run() {
            if (this.registration != null) {
                this.registration.unregister();
            }
        }

        private FeaturesService getFeaturesService() {
            if (this.serviceTracker == null) {
                this.serviceTracker = new ServiceTracker(this.context, FeaturesService.class.getName(), null);
                this.serviceTracker.open();
            }
            return (FeaturesService)this.serviceTracker.getService();
        }

        @Override
        public Set<String> call() {
            return this.getFeatureLocations(this.getFeatures());
        }

        private Set<String> getFeatures() {
            LinkedHashSet<String> features = new LinkedHashSet<String>();
            try {
                for (Feature feature : this.featuresService.listFeatures()) {
                    features.addAll(this.getFeatures(feature.getName()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return features;
        }

        private Set<String> getFeatures(String feature) throws Exception {
            LinkedHashSet<String> features = new LinkedHashSet<String>();
            features.add(feature);
            Feature f = this.featuresService.getFeature(feature);
            for (Feature dependency : f.getDependencies()) {
                features.add(dependency.getName());
            }
            return features;
        }

        private Set<String> getFeatureLocations(Set<String> features) {
            LinkedHashSet<String> bundleLocations = new LinkedHashSet<String>();
            for (String feature : features) {
                try {
                    Feature f = this.featuresService.getFeature(feature);
                    for (BundleInfo info : f.getBundles()) {
                        bundleLocations.add(info.getLocation());
                    }
                }
                catch (Exception e) {
                }
            }
            return bundleLocations;
        }
    }

    private static class FeaturesServiceSupport
    implements Runnable {
        private BundleContext context;
        private ServiceRegistration registration;
        private ServiceTracker serviceTracker;

        private FeaturesServiceSupport(BundleContext context) {
            this.context = context;
            FeaturesService featuresService = this.getFeaturesService();
            AllFeatureCompleter allFeatureCompleter = new AllFeatureCompleter();
            allFeatureCompleter.setFeaturesService(featuresService);
            FeaturesCompleterDelegate.DELEGATE = allFeatureCompleter;
            FeatureRepositoryCompleter featureRepositoryCompleter = new FeatureRepositoryCompleter();
            featureRepositoryCompleter.setFeaturesService(featuresService);
            FeaturesRepositoryCompleterDelegate.DELEGATE = featureRepositoryCompleter;
        }

        @Override
        public void run() {
            FeaturesCompleterDelegate.DELEGATE = null;
            FeaturesRepositoryCompleterDelegate.DELEGATE = null;
            if (this.registration != null) {
                this.registration.unregister();
            }
        }

        private FeaturesService getFeaturesService() {
            this.serviceTracker = new ServiceTracker(this.context, FeaturesService.class.getName(), null);
            this.serviceTracker.open();
            return (FeaturesService)this.serviceTracker.getService();
        }
    }
}

