/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="container-connect", scope="fabric", description="Connect to a remote container")
public class ContainerConnect
extends FabricCommand {
    @Option(name="-u", aliases={"--username"}, description="Remote user name (Default: admin)", required=false, multiValued=false)
    private String username = "admin";
    @Option(name="-p", aliases={"--password"}, description="Remote user password (Default: admin)", required=false, multiValued=false)
    private String password = "admin";
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container = null;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;

    protected Object doExecute() throws Exception {
        Container found;
        String sshUrl;
        this.checkFabricAvailable();
        String cmdStr = "";
        if (this.command != null) {
            StringBuilder sb = new StringBuilder();
            for (String cmd : this.command) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(cmd);
            }
            cmdStr = "'" + sb.toString().replaceAll("'", "\\'") + "'";
        }
        if ((sshUrl = (found = this.getContainer(this.container)).getSshUrl()) == null) {
            throw new IllegalArgumentException("Container " + this.container + " has no SSH URL.");
        }
        String[] ssh = sshUrl.split(":");
        if (ssh.length < 2) {
            throw new IllegalArgumentException("Container " + this.container + " has an invalid SSH URL '" + sshUrl + "'");
        }
        this.session.execute((CharSequence)("ssh -l " + this.username + " -P " + this.password + " -p " + ssh[1] + " " + ssh[0] + " " + cmdStr));
        return null;
    }
}

