/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="patch-list-upgrades", scope="fabric", description="Display the list of possible patch upgrades")
public class PatchListUpgrades
extends FabricCommand {
    @Option(name="--version", description="Only list upgrades for the given version")
    private String version;
    @Option(name="--profile", description="Only list upgrades for the given profile (if no version is specified, the default one is used")
    private String profile;

    protected Object doExecute() throws Exception {
        Version v = null;
        if (this.version != null && !this.version.isEmpty()) {
            v = this.fabricService.getVersion(this.version);
        }
        Profile p = null;
        if (this.profile != null && !this.profile.isEmpty()) {
            if (v == null) {
                v = this.fabricService.getDefaultVersion();
            }
            p = v.getProfile(this.profile);
        }
        Map upgrades = p != null ? this.fabricService.getPatchService().getPossibleUpgrades(p) : (v != null ? this.fabricService.getPatchService().getPossibleUpgrades(v) : this.fabricService.getPatchService().getPossibleUpgrades());
        for (Map.Entry entry : upgrades.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            System.out.println((String)entry.getKey());
            for (String version : (Set)entry.getValue()) {
                System.out.println("\t" + version);
            }
        }
        return null;
    }
}

