/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import java.util.Collection;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.FabricStatus;
import org.fusesource.fabric.api.ProfileStatus;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="status", scope="fabric", description="Displays the current status of the fabric by comparing the requirements to the actual instance counts", detailedDescription="classpath:status.txt")
public class Status
extends FabricCommand {
    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        PrintStream out = System.out;
        FabricStatus status = this.getFabricService().getFabricStatus();
        this.printStatus(out, status);
        return null;
    }

    protected void printStatus(PrintStream out, FabricStatus status) {
        out.println(String.format("%-40s %-14s %s", "[profile]", "[instances]", "[health]"));
        Collection statuses = status.getProfileStatusMap().values();
        for (ProfileStatus profile : statuses) {
            String id = profile.getProfile();
            int instances = profile.getCount();
            Integer minimum = profile.getMinimumInstances();
            Integer maximum = profile.getMaximumInstances();
            double health = profile.getHealth(instances);
            out.println(String.format("%-40s %-14s %s", id, instances, this.percentText(health)));
        }
    }
}

