/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.helper.BaseTracker;
import org.apache.felix.cm.impl.helper.ConfigurationMap;
import org.apache.felix.cm.impl.helper.ManagedServiceConfigurationMap;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedServiceTracker
extends BaseTracker<ManagedService> {
    private static final Dictionary<String, ?> INITIAL_MARKER = new Hashtable(0);

    public ManagedServiceTracker(ConfigurationManager cm) {
        super(cm, false);
    }

    @Override
    protected ConfigurationMap<?> createConfigurationMap(String[] pids) {
        return new ManagedServiceConfigurationMap(pids);
    }

    @Override
    public String getServicePid(ServiceReference<ManagedService> service, TargetedPID pid) {
        ConfigurationMap configs = (ConfigurationMap)this.getService(service);
        if (configs != null) {
            return configs.getKeyPid(pid);
        }
        return null;
    }

    @Override
    public void provideConfiguration(ServiceReference<ManagedService> service, TargetedPID configPid, TargetedPID factoryPid, Dictionary<String, ?> properties, long revision) {
        Dictionary<String, ?> supplied = properties == null ? INITIAL_MARKER : properties;
        this.updateService(service, configPid, supplied, revision);
    }

    @Override
    public void removeConfiguration(ServiceReference<ManagedService> service, TargetedPID configPid, TargetedPID factoryPid) {
        this.updateService(service, configPid, null, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateService(ServiceReference<ManagedService> service, TargetedPID configPid, Dictionary<String, ?> properties, long revision) {
        ManagedService srv = this.getRealService(service);
        ConfigurationMap configs = (ConfigurationMap)this.getService(service);
        if (srv != null && configs != null) {
            boolean doUpdate = false;
            if (properties == null) {
                doUpdate = configs.removeConfiguration(configPid, null);
            } else if (properties == INITIAL_MARKER) {
                properties = null;
                revision = -1L;
                doUpdate = true;
            } else if (revision < 0L || configs.shallTake(configPid, null, revision)) {
                properties = this.getProperties(properties, service, configPid.toString(), null);
                doUpdate = true;
                revision = Math.abs(revision);
            } else {
                doUpdate = false;
            }
            if (doUpdate) {
                try {
                    srv.updated(properties);
                    configs.record(configPid, null, revision);
                }
                catch (Throwable t) {
                    this.handleCallBackError(t, service, configPid);
                }
                finally {
                    this.ungetRealService(service);
                }
            }
        }
    }
}

