/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import org.fusesource.fabric.fab.MavenResolver;
import org.fusesource.fabric.fab.MavenResolverImpl;
import org.fusesource.fabric.fab.osgi.ServiceConstants;
import org.fusesource.fabric.fab.osgi.internal.Configuration;
import org.fusesource.fabric.fab.osgi.util.ConfigurationAdminHelper;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertiesPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private PropertyResolver propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.propertyResolver = propertyResolver;
    }

    public static ConfigurationImpl newInstance() {
        PropertiesPropertyResolver resolver = new PropertiesPropertyResolver(System.getProperties());
        return new ConfigurationImpl(resolver);
    }

    public static ConfigurationImpl newInstance(ConfigurationAdmin admin, BundleContext context) {
        DictionaryPropertyResolver resolver = new DictionaryPropertyResolver(ConfigurationAdminHelper.getProperties(admin, "org.fusesource.fabric.fab.osgi.url"), new DictionaryPropertyResolver(ConfigurationAdminHelper.getProperties(admin, "org.ops4j.pax.url.mvn"), new BundleContextPropertyResolver(context)));
        return new ConfigurationImpl(resolver);
    }

    @Override
    public boolean getCertificateCheck() {
        if (!this.contains("org.fusesource.fabric.fab.osgi.url.certificateCheck")) {
            return this.set("org.fusesource.fabric.fab.osgi.url.certificateCheck", Boolean.valueOf(this.propertyResolver.get("org.fusesource.fabric.fab.osgi.url.certificateCheck")));
        }
        return (Boolean)this.get("org.fusesource.fabric.fab.osgi.url.certificateCheck");
    }

    @Override
    public boolean isInstallMissingDependencies() {
        String value;
        if (!this.contains("org.fusesource.fabric.fab.osgi.url.installProvidedDependencies") && (value = this.propertyResolver.get("org.fusesource.fabric.fab.osgi.url.installProvidedDependencies")) != null) {
            Boolean aBoolean = Boolean.valueOf(value);
            return this.set("org.fusesource.fabric.fab.osgi.url.installProvidedDependencies", aBoolean);
        }
        Boolean answer = (Boolean)this.get("org.fusesource.fabric.fab.osgi.url.installProvidedDependencies");
        if (answer == null) {
            return true;
        }
        return answer;
    }

    @Override
    public MavenResolver getResolver() {
        String localrepo;
        MavenResolverImpl resolver = new MavenResolverImpl();
        String[] repositories = this.getMavenRepositories();
        if (repositories != null) {
            resolver.setRepositories(repositories);
        }
        if ((localrepo = this.getLocalMavenRepository()) != null) {
            resolver.setLocalRepo(localrepo);
        }
        return resolver;
    }

    public String[] getMavenRepositories() {
        if (!this.contains("org.ops4j.pax.url.mvn.repositories")) {
            String text = this.propertyResolver.get("org.ops4j.pax.url.mvn.repositories");
            String[] repositories = ConfigurationImpl.toArray(text);
            return this.set("org.ops4j.pax.url.mvn.repositories", repositories);
        }
        return (String[])this.get("org.ops4j.pax.url.mvn.repositories");
    }

    public String getLocalMavenRepository() {
        if (!this.contains("org.ops4j.pax.url.mvn.localRepository")) {
            String text = this.propertyResolver.get("org.ops4j.pax.url.mvn.localRepository");
            return this.set("org.ops4j.pax.url.mvn.localRepository", text);
        }
        return (String)this.get("org.ops4j.pax.url.mvn.localRepository");
    }

    @Override
    public String[] getSharedResourcePaths() {
        if (!this.contains("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths")) {
            String text = this.propertyResolver.get("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths");
            String[] repositories = text == null || text.length() == 0 ? ServiceConstants.DEFAULT_PROPERTY_SHARED_RESOURCE_PATHS : ConfigurationImpl.toArray(text);
            return this.set("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths", repositories);
        }
        return (String[])this.get("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths");
    }

    protected static String[] toArray(String text) {
        String[] answer = null;
        if (text != null) {
            answer = text.split(",");
        }
        return answer;
    }

    protected PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }
}

