/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionRange;
import org.sonatype.aether.version.VersionScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternInclusionsDependencyFilter
implements DependencyFilter {
    private final Collection<String> patterns = new HashSet<String>();
    private final VersionScheme versionScheme;

    public PatternInclusionsDependencyFilter(String ... patterns) {
        this((VersionScheme)null, patterns);
    }

    public PatternInclusionsDependencyFilter(VersionScheme versionScheme, String ... patterns) {
        this(versionScheme, patterns == null ? null : Arrays.asList(patterns));
    }

    public PatternInclusionsDependencyFilter(Collection<String> patterns) {
        this(null, patterns);
    }

    public PatternInclusionsDependencyFilter(VersionScheme versionScheme, Collection<String> patterns) {
        if (patterns != null) {
            this.patterns.addAll(patterns);
        }
        this.versionScheme = versionScheme;
    }

    @Override
    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return true;
        }
        Artifact artifact = dependency.getArtifact();
        for (String pattern : this.patterns) {
            boolean matched = this.accept(artifact, pattern);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private boolean accept(Artifact artifact, String pattern) {
        String[] tokens = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getBaseVersion()};
        String[] patternTokens = pattern.split(":");
        boolean matched = patternTokens.length <= tokens.length;
        for (int i = 0; matched && i < patternTokens.length; ++i) {
            matched = this.matches(tokens[i], patternTokens[i]);
        }
        return matched;
    }

    private boolean matches(String token, String pattern) {
        boolean matches;
        if ("*".equals(pattern) || pattern.length() == 0) {
            matches = true;
        } else if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String contains = pattern.substring(1, pattern.length() - 1);
            matches = token.indexOf(contains) != -1;
        } else if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1, pattern.length());
            matches = token.endsWith(suffix);
        } else if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            matches = token.startsWith(prefix);
        } else {
            matches = pattern.startsWith("[") || pattern.startsWith("(") ? this.isVersionIncludedInRange(token, pattern) : token.equals(pattern);
        }
        return matches;
    }

    private boolean isVersionIncludedInRange(String version, String range) {
        if (this.versionScheme == null) {
            return false;
        }
        try {
            Version parsedVersion = this.versionScheme.parseVersion(version);
            VersionRange parsedRange = this.versionScheme.parseVersionRange(range);
            return parsedRange.containsVersion(parsedVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PatternInclusionsDependencyFilter that = (PatternInclusionsDependencyFilter)obj;
        return ((Object)this.patterns).equals(that.patterns) && (this.versionScheme == null ? that.versionScheme == null : this.versionScheme.equals(that.versionScheme));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + ((Object)this.patterns).hashCode();
        hash = hash * 31 + (this.versionScheme == null ? 0 : this.versionScheme.hashCode());
        return hash;
    }
}

