/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.pool.ConnectionPool;
import org.apache.activemq.pool.PooledSession;
import org.apache.commons.pool.ObjectPoolFactory;

public class XaConnectionPool
extends ConnectionPool {
    private TransactionManager transactionManager;

    public XaConnectionPool(ActiveMQConnection connection, ObjectPoolFactory poolFactory, TransactionManager transactionManager) {
        super(connection, poolFactory);
        this.transactionManager = transactionManager;
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        try {
            boolean isXa;
            boolean bl = isXa = this.transactionManager != null && this.transactionManager.getStatus() != 6;
            if (isXa) {
                transacted = true;
                ackMode = 0;
            }
            PooledSession session = (PooledSession)super.createSession(transacted, ackMode);
            if (isXa) {
                session.setIgnoreClose(true);
                session.setIsXa(true);
                this.transactionManager.getTransaction().registerSynchronization((javax.transaction.Synchronization)new Synchronization(session));
                this.incrementReferenceCount();
                this.transactionManager.getTransaction().enlistResource(this.createXaResource(session));
            } else {
                session.setIgnoreClose(false);
            }
            return session;
        }
        catch (RollbackException e) {
            JMSException jmsException = new JMSException("Rollback Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
        catch (SystemException e) {
            JMSException jmsException = new JMSException("System Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
    }

    protected XAResource createXaResource(PooledSession session) throws JMSException {
        return session.getXAResource();
    }

    protected class Synchronization
    implements javax.transaction.Synchronization {
        private final PooledSession session;

        private Synchronization(PooledSession session) {
            this.session = session;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.session.setIgnoreClose(false);
                this.session.close();
                this.session.setIgnoreClose(true);
                this.session.setIsXa(false);
                XaConnectionPool.this.decrementReferenceCount();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

