/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.maven.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.maven.impl.InvalidMavenArtifactRequest;
import org.fusesource.fabric.maven.impl.MavenProxyServletSupport;

public class MavenDownloadProxyServlet
extends MavenProxyServletSupport {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        FileInputStream inputStream = null;
        try {
            File artifactFile;
            String path = req.getPathInfo();
            if (path != null && path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((artifactFile = this.download(path)) == null) {
                resp.setStatus(404);
                return;
            }
            try {
                int length;
                inputStream = new FileInputStream(artifactFile);
                LOGGER.log(Level.INFO, String.format("Writing response for file : %s", path));
                resp.setStatus(200);
                resp.setContentType("application/octet-stream");
                resp.setDateHeader("Date", System.currentTimeMillis());
                resp.setHeader("Connection", "close");
                resp.setContentLength(((InputStream)inputStream).available());
                resp.setHeader("Server", "MavenProxy Proxy/" + FabricConstants.FABRIC_VERSION);
                byte[] buffer = new byte[4096];
                while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                    resp.getOutputStream().write(buffer, 0, length);
                }
                resp.getOutputStream().flush();
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        catch (InvalidMavenArtifactRequest ex) {
            resp.sendError(400, ex.getMessage());
        }
        catch (Exception ex) {
            resp.setStatus(500);
        }
    }
}

