/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.VersionSequence;
import org.fusesource.fabric.service.FabricServiceImpl;

public class VersionImpl
implements Version {
    private final String name;
    private final FabricServiceImpl service;
    private final VersionSequence sequence;

    public VersionImpl(String name, FabricServiceImpl service) {
        this.name = name;
        this.service = service;
        this.sequence = new VersionSequence(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VersionSequence getSequence() {
        return this.sequence;
    }

    @Override
    public int compareTo(Version that) {
        return this.sequence.compareTo(that.getSequence());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionImpl version = (VersionImpl)o;
        return !(this.name != null ? !this.name.equals(version.name) : version.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public Version getDerivedFrom() {
        return null;
    }

    @Override
    public Profile[] getProfiles() {
        return this.service.getProfiles(this.name);
    }

    @Override
    public Profile getProfile(String name) {
        return this.service.getProfile(this.name, name);
    }

    @Override
    public Profile createProfile(String name) {
        return this.service.createProfile(this.name, name);
    }

    @Override
    public void delete() {
        this.service.deleteVersion(this.name);
    }

    public String toString() {
        return this.name;
    }
}

