/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.CreateContainerChildMetadata;
import org.fusesource.fabric.api.CreateContainerChildOptions;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.service.ContainerTemplate;
import org.fusesource.fabric.service.FabricServiceImpl;

public class ChildContainerProvider
implements ContainerProvider<CreateContainerChildOptions, CreateContainerChildMetadata> {
    final FabricServiceImpl service;

    public ChildContainerProvider(FabricServiceImpl service) {
        this.service = service;
    }

    @Override
    public Set<CreateContainerChildMetadata> create(final CreateContainerChildOptions options) throws Exception {
        final LinkedHashSet<CreateContainerChildMetadata> result = new LinkedHashSet<CreateContainerChildMetadata>();
        String parentName = options.getParent();
        Container parent = this.service.getContainer(parentName);
        ContainerTemplate containerTemplate = this.service.getContainerTemplate(parent);
        if (options.getProviderURI() != null && options.getProviderURI().getUserInfo() != null) {
            String[] uip;
            String ui = options.getProviderURI().getUserInfo();
            String[] stringArray = uip = ui != null ? ui.split(":") : null;
            if (uip != null) {
                containerTemplate.setLogin(uip[0]);
                containerTemplate.setPassword(uip[1]);
            }
        }
        containerTemplate.execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                StringBuilder jvmOptsBuilder = new StringBuilder();
                if (options.getJvmOpts() != null && !options.getJvmOpts().isEmpty()) {
                    jvmOptsBuilder.append(options.getJvmOpts()).append(" ");
                }
                jvmOptsBuilder.append("-server -Dcom.sun.management.jmxremote ").append(options.getZookeeperUrl() != null ? "-Dzookeeper.url=\"" + options.getZookeeperUrl() + "\"" : "");
                if (options.getJvmOpts() == null || !options.getJvmOpts().contains("-Xmx")) {
                    jvmOptsBuilder.append(" -Xmx512m");
                } else if (options.getJvmOpts() != null) {
                    jvmOptsBuilder.append(" ").append(options.getJvmOpts());
                }
                if (options.isEnsembleServer()) {
                    jvmOptsBuilder.append(" ").append(" -Densemble.auto.start=true");
                }
                String features = "fabric-agent";
                String featuresUrls = "mvn:org.fusesource.fabric/fuse-fabric/" + FabricConstants.FABRIC_VERSION + "/xml/features";
                String originalName = new String(options.getName());
                for (int i = 1; i <= options.getNumber(); ++i) {
                    String containerName = options.getNumber() > 1 ? originalName + i : originalName;
                    CreateContainerChildMetadata metadata = new CreateContainerChildMetadata();
                    metadata.setCreateOptions(options);
                    metadata.setContainerName(containerName);
                    try {
                        adminService.createInstance(containerName, 0, 0, 0, null, jvmOptsBuilder.toString(), features, featuresUrls);
                        adminService.startInstance(containerName, null);
                    }
                    catch (Throwable t) {
                        metadata.setFailure(t);
                    }
                    result.add(metadata);
                }
                return null;
            }
        });
        return result;
    }

    @Override
    public void start(final Container container) {
        this.getContainerTemplate(container.getParent()).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.startInstance(container.getId(), null);
                return null;
            }
        });
    }

    @Override
    public void stop(final Container container) {
        this.getContainerTemplate(container.getParent()).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.stopInstance(container.getId());
                return null;
            }
        });
    }

    @Override
    public void destroy(final Container container) {
        this.getContainerTemplate(container.getParent()).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                block2: {
                    try {
                        adminService.stopInstance(container.getId());
                    }
                    catch (Exception e) {
                        if (!container.isAlive()) break block2;
                        throw e;
                    }
                }
                adminService.destroyInstance(container.getId());
                return null;
            }
        });
    }

    protected ContainerTemplate getContainerTemplate(Container container) {
        return new ContainerTemplate(container, false, this.service.getUserName(), this.service.getPassword());
    }
}

