/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.fusesource.fabric.fab.Content;
import org.fusesource.fabric.fab.DependencyClassLoader;

public class TreeClassLoader
extends SecureClassLoader {
    private final List<DependencyClassLoader> childClassLoaders;

    public TreeClassLoader(List<DependencyClassLoader> childClassLoaders, ClassLoader parent) {
        super(parent);
        this.childClassLoaders = childClassLoaders;
    }

    public String toString() {
        return "TreeClassLoader[" + this.childClassLoaders + "]";
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            for (DependencyClassLoader childClassLoader : this.childClassLoaders) {
                try {
                    c = childClassLoader.loadClass(name, false);
                    if (c == null) continue;
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        if (c == null) {
            try {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                c = cl.loadClass(name);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String actual = name.replace('.', '/') + ".class";
        byte[] bytes = null;
        if (bytes != null) {
            TreeClassLoader treeClassLoader = this;
            synchronized (treeClassLoader) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz == null) {
                    clazz = this.defineClass(name, bytes, 0, bytes.length);
                }
                return clazz;
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getContentEntry(Content jar, String actual) {
        InputStream is = null;
        try {
            URL url = jar.getURL(actual);
            if (url != null) {
                is = url.openStream();
            }
            if (is != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                byte[] buf = new byte[4096];
                int n = 0;
                while ((n = is.read(buf, 0, buf.length)) >= 0) {
                    baos.write(buf, 0, n);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        for (DependencyClassLoader childClassLoader : this.childClassLoaders) {
            URL url = childClassLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> list = new Vector<URL>();
        for (DependencyClassLoader childClassLoader : this.childClassLoaders) {
            Enumeration<URL> e = childClassLoader.getResources(name);
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
        }
        return list.elements();
    }
}

