/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.RrdNioBackend;

public class RrdNioBackendFactory
extends RrdFileBackendFactory {
    public static final int DEFAULT_SYNC_PERIOD = 300;
    private static int syncPeriod = 300;
    public static final int DEFAULT_SYNC_CORE_POOL_SIZE = 6;
    private final ScheduledExecutorService syncExecutor = Executors.newScheduledThreadPool(6, new DaemonThreadFactory("RRD4J Sync"));

    public RrdNioBackendFactory() {
        Runtime.getRuntime().addShutdownHook(new Thread("RRD4J Sync-ThreadPool-Shutdown"){

            public void run() {
                try {
                    RrdNioBackendFactory.this.syncExecutor.shutdown();
                    RrdNioBackendFactory.this.syncExecutor.awaitTermination(120L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public static int getSyncPeriod() {
        return syncPeriod;
    }

    public static void setSyncPeriod(int syncPeriod) {
        RrdNioBackendFactory.syncPeriod = syncPeriod;
    }

    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        return new RrdNioBackend(path, readOnly, this.syncExecutor, syncPeriod);
    }

    public String getName() {
        return "NIO";
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final String nameSuffix = "]";

        DaemonThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + " Pool [Thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement() + "]");
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

