/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.rrd4j.core.ArcState;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.InspectorModel;
import org.rrd4j.inspector.Util;

class ArchiveTableModel
extends AbstractTableModel {
    private static final Object[] DESCRIPTIONS = new Object[]{"consolidation", "xff", "steps", "rows", "accum. value", "NaN steps", "start", "end"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private File file;
    private Object[] values;
    private int dsIndex = -1;
    private int arcIndex = -1;

    ArchiveTableModel() {
    }

    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return DESCRIPTIONS[rowIndex];
        }
        if (columnIndex == 1) {
            if (this.values != null) {
                return this.values[rowIndex];
            }
            return "--";
        }
        return null;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    void setFile(File newFile) {
        this.file = newFile;
        this.setIndex(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndex(int newDsIndex, int newArcIndex) {
        if (this.dsIndex != newDsIndex || this.arcIndex != newArcIndex) {
            this.dsIndex = newDsIndex;
            this.arcIndex = newArcIndex;
            this.values = null;
            if (this.dsIndex >= 0 && this.arcIndex >= 0) {
                try {
                    RrdDb rrd = new RrdDb(this.file.getAbsolutePath(), true);
                    try {
                        Archive arc = rrd.getArchive(this.arcIndex);
                        ArcState state = arc.getArcState(this.dsIndex);
                        this.values = new Object[]{arc.getConsolFun(), "" + arc.getXff(), "" + arc.getSteps(), "" + arc.getRows(), InspectorModel.formatDouble(state.getAccumValue()), "" + state.getNanSteps(), "" + arc.getStartTime() + " [" + new Date(arc.getStartTime() * 1000L) + "]", "" + arc.getEndTime() + " [" + new Date(arc.getEndTime() * 1000L) + "]"};
                    }
                    finally {
                        rrd.close();
                    }
                }
                catch (Exception e) {
                    Util.error(null, e);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

