/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.InspectorModel;
import org.rrd4j.inspector.Util;

class DataTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"timestamp", "date", "value"};
    private File file;
    private Object[][] values;
    private int dsIndex = -1;
    private int arcIndex = -1;

    DataTableModel() {
    }

    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.values == null) {
            return "--";
        }
        return this.values[rowIndex][columnIndex];
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        double value;
        assert (columnIndex == 2) : "Column " + columnIndex + " is not editable!";
        try {
            value = Double.parseDouble(aValue.toString());
        }
        catch (NumberFormatException nfe) {
            value = Double.NaN;
        }
        if (this.dsIndex >= 0 && this.arcIndex >= 0 && this.file != null) {
            try {
                RrdDb rrd = new RrdDb(this.file.getAbsolutePath());
                try {
                    Robin robin = rrd.getArchive(this.arcIndex).getRobin(this.dsIndex);
                    robin.setValue(rowIndex, value);
                    this.values[rowIndex][2] = InspectorModel.formatDouble(robin.getValue(rowIndex));
                }
                finally {
                    rrd.close();
                }
            }
            catch (Exception e) {
                Util.error(null, e);
            }
        }
    }

    void setFile(File newFile) {
        this.file = newFile;
        this.setIndex(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndex(int newDsIndex, int newArcIndex) {
        if (this.dsIndex != newDsIndex || this.arcIndex != newArcIndex) {
            this.dsIndex = newDsIndex;
            this.arcIndex = newArcIndex;
            this.values = null;
            if (this.dsIndex >= 0 && this.arcIndex >= 0) {
                try {
                    RrdDb rrd = new RrdDb(this.file.getAbsolutePath(), true);
                    try {
                        Archive arc = rrd.getArchive(this.arcIndex);
                        Robin robin = arc.getRobin(this.dsIndex);
                        long start = arc.getStartTime();
                        long step = arc.getArcStep();
                        double[] robinValues = robin.getValues();
                        this.values = new Object[robinValues.length][];
                        for (int i = 0; i < robinValues.length; ++i) {
                            long timestamp = start + (long)i * step;
                            String date = new Date(timestamp * 1000L).toString();
                            String value = InspectorModel.formatDouble(robinValues[i]);
                            this.values[i] = new Object[]{"" + timestamp, date, value};
                        }
                    }
                    finally {
                        rrd.close();
                    }
                }
                catch (Exception e) {
                    Util.error(null, e);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

