/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.service.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.util.OsgiUtil;
import org.osgi.framework.Bundle;

public class PaxLoggerImpl
implements PaxLogger {
    private Logger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    private void setDelegateContext() {
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            Iterator keys = context.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = context.get(key);
                MDC.put(key, value);
            }
        }
        if (this.m_bundle != null) {
            this.put("bundle.id", new Long(this.m_bundle.getBundleId()));
            this.put("bundle.name", OsgiUtil.getBundleSymbolicName(this.m_bundle));
            this.put("bundle.version", OsgiUtil.getVersion(this.m_bundle));
        }
        this.m_service.getConfigLock().readLock().lock();
    }

    private void put(String name, Object o) {
        if (o != null) {
            MDC.put(name, o);
        }
    }

    private void clearDelegateContext() {
        this.m_service.getConfigLock().readLock().unlock();
        if (MDC.getContext() != null) {
            MDC.getContext().clear();
        }
    }

    public void trace(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.TRACE, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    public void debug(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.DEBUG, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    public void inform(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.INFO, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
    }

    public void warn(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.WARN, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
    }

    public void error(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.ERROR, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    public void fatal(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.FATAL, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    public void trace(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.TRACE, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    public void debug(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.DEBUG, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    public void inform(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.INFO, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
    }

    public void warn(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.WARN, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
    }

    public void error(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.ERROR, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    public void fatal(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.FATAL, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    public int getLogLevel() {
        return this.m_delegate.getLevel().toInt();
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public void log(Priority level, Object message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, level, message, t);
        this.clearDelegateContext();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }
}

