/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.List;
import java.util.Queue;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineService;
import org.apache.karaf.shell.console.OsgiCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaasCommandSupport
extends OsgiCommandSupport {
    public static final String JAAS_REALM = "JaasCommand.REALM";
    public static final String JAAS_ENTRY = "JaasCommand.ENTRY";
    public static final String JAAS_CMDS = "JaasCommand.COMMANDS";
    private List<JaasRealm> realms;
    protected BackingEngineService backingEngineService;

    protected abstract Object doExecute(BackingEngine var1) throws Exception;

    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get(JAAS_REALM);
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get(JAAS_ENTRY);
        Queue commandQueue = (Queue)this.session.get(JAAS_CMDS);
        if (realm != null && entry != null) {
            if (commandQueue != null) {
                commandQueue.add(this);
            }
        } else {
            System.err.println("No JAAS Realm / Module has been selected.");
        }
        return null;
    }

    public JaasRealm findRealmByNameOrIndex(String realmName, int index) {
        JaasRealm realm = null;
        if (this.realms != null) {
            for (int i = 1; i <= this.realms.size(); ++i) {
                if (!this.realms.get(i - 1).getName().equals(realmName) && index != i) continue;
                return this.realms.get(i - 1);
            }
        }
        return realm;
    }

    public AppConfigurationEntry findEntryByRealmAndName(JaasRealm realm, String moduleName) {
        AppConfigurationEntry appConfigurationEntry = null;
        if (realm != null) {
            AppConfigurationEntry[] entries = realm.getEntries();
            if (entries != null && entries.length == 1 && moduleName == null) {
                return entries[0];
            }
            for (AppConfigurationEntry entry : entries) {
                String moduleClass = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
                if (!moduleName.equals(entry.getLoginModuleName()) && !moduleName.equals(moduleClass)) continue;
                return entry;
            }
        }
        return appConfigurationEntry;
    }

    public List<JaasRealm> getRealms() {
        return this.realms;
    }

    public void setRealms(List<JaasRealm> realms) {
        this.realms = realms;
    }

    public BackingEngineService getBackingEngineService() {
        return this.backingEngineService;
    }

    public void setBackingEngineService(BackingEngineService backingEngineService) {
        this.backingEngineService = backingEngineService;
    }
}

