/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

public class Path {
    private Path() {
    }

    public static String normalizeResourcePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = Path.replaceSlashes(path.trim());
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    static String replaceSlashes(String target) {
        String replaced = target;
        if (replaced != null) {
            replaced = replaced.replaceAll("/+", "/");
        }
        return replaced;
    }

    public static String[] normalizePatterns(String[] urlPatterns) {
        String[] normalized = null;
        if (urlPatterns != null) {
            normalized = new String[urlPatterns.length];
            for (int i = 0; i < urlPatterns.length; ++i) {
                normalized[i] = Path.normalizePattern(urlPatterns[i]);
            }
        }
        return normalized;
    }

    public static String normalizePattern(String pattern) {
        if (pattern != null && pattern.length() > 0 && !pattern.startsWith("/") && !pattern.startsWith("*")) {
            return "/" + pattern;
        }
        return pattern;
    }
}

