/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.fusesource.fabric.api.data.BundleInfo;
import org.fusesource.fabric.internal.JmxInfo;

public class JmxBundleInfo
extends JmxInfo
implements BundleInfo {
    public JmxBundleInfo(CompositeData data) {
        super(data, "Identifier");
    }

    @Override
    public BundleInfo.State getState() {
        return BundleInfo.State.valueOf((String)this.data.get("State"));
    }

    @Override
    public String getSymbolicName() {
        return (String)this.data.get("SymbolicName");
    }

    @Override
    public BundleInfo.Header[] getHeaders() {
        TabularData headers = (TabularData)this.data.get("Headers");
        BundleInfo.Header[] hdr = new BundleInfo.Header[headers.size()];
        int i = 0;
        for (CompositeData data : headers.values()) {
            String key = data.get("Key").toString();
            String value = data.get("Value").toString();
            hdr[i++] = new HeaderImpl(key, value);
        }
        return hdr;
    }

    @Override
    public String getVersion() {
        return (String)this.data.get("Version");
    }

    @Override
    public String[] getImportPackages() {
        return (String[])this.data.get("ImportedPackages");
    }

    @Override
    public String[] getExportPackages() {
        return (String[])this.data.get("ExportedPackages");
    }

    static class HeaderImpl
    implements BundleInfo.Header {
        final String key;
        final String value;

        HeaderImpl(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

