/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.util.Map;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.MQService;
import org.fusesource.fabric.api.Profile;

public class MQServiceImpl
implements MQService {
    private FabricService fabricService;

    public MQServiceImpl(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    @Override
    public Profile createMQProfile(String version, String brokerName, Map<String, String> configs) {
        Profile parentProfile = this.fabricService.getProfile(version, "mq-base");
        String pidName = "org.fusesource.mq.fabric.server-" + brokerName;
        Profile result = parentProfile;
        if (brokerName != null) {
            result = this.fabricService.getProfile(version, brokerName);
            Map<String, String> config = null;
            if (result == null) {
                result = this.fabricService.createProfile(version, brokerName);
                result.setParents(new Profile[]{parentProfile});
            } else {
                config = result.getConfigurations().get(pidName);
            }
            if (config == null) {
                config = parentProfile.getConfigurations().get("org.fusesource.mq.fabric.template");
            }
            config.put("broker-name", brokerName);
            if (configs != null) {
                config.putAll(configs);
            }
            Map<String, Map<String, String>> newConfigs = result.getConfigurations();
            newConfigs.put(pidName, config);
            result.setConfigurations(newConfigs);
        }
        return result;
    }

    @Override
    public String getConfig(String version, String config) {
        return "zk:/fabric/configs/versions/" + version + "/profiles/mq-base/" + config;
    }
}

