/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.util.IOHelper;

public class FileInputStreamCache
extends InputStream
implements StreamCache {
    private InputStream stream;
    private File file;

    public FileInputStreamCache(File file) throws FileNotFoundException {
        this.file = file;
        this.stream = null;
    }

    @Override
    public void close() {
        if (this.stream != null) {
            IOHelper.close((Closeable)this.stream);
        }
    }

    @Override
    public void reset() {
        this.close();
        this.stream = null;
        if (!this.file.exists()) {
            throw new RuntimeCamelException("Cannot reset stream from file " + this.file);
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.stream == null) {
            long i;
            FileInputStream s = new FileInputStream(this.file);
            long len = this.file.length();
            WritableByteChannel out = os instanceof WritableByteChannel ? (WritableByteChannel)((Object)os) : Channels.newChannel(os);
            FileChannel fc = s.getChannel();
            for (long pos = 0L; pos < len; pos += i) {
                i = fc.transferTo(pos, len - pos, out);
            }
            s.close();
        } else {
            IOHelper.copy(this.getInputStream(), os);
        }
    }

    @Override
    public int available() throws IOException {
        return this.getInputStream().available();
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    protected InputStream getInputStream() throws IOException {
        if (this.stream == null) {
            this.stream = IOHelper.buffered(new FileInputStream(this.file));
        }
        return this.stream;
    }
}

