/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="log")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LogDefinition
extends NoOutputDefinition<LogDefinition> {
    @XmlAttribute(required=true)
    private String message;
    @XmlAttribute
    private LoggingLevel loggingLevel;
    @XmlAttribute
    private String logName;
    @XmlAttribute
    private String marker;

    public LogDefinition() {
    }

    public LogDefinition(String message) {
        this.message = message;
    }

    public String toString() {
        return "Log[" + this.message + "]";
    }

    @Override
    public String getLabel() {
        return "log";
    }

    @Override
    public String getShortName() {
        return "log";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notEmpty(this.message, "message", this);
        Expression exp = routeContext.getCamelContext().resolveLanguage("simple").createExpression(this.message);
        String name = this.getLogName();
        if (name == null) {
            name = routeContext.getRoute().getId();
        }
        LoggingLevel level = this.getLoggingLevel() != null ? this.getLoggingLevel() : LoggingLevel.INFO;
        CamelLogger logger = new CamelLogger(name, level, this.getMarker());
        return new LogProcessor(exp, logger);
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        this.getParent().addOutput(output);
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }
}

