/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enricher
extends ServiceSupport
implements AsyncProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(Enricher.class);
    private AggregationStrategy aggregationStrategy;
    private Producer producer;

    public Enricher(Producer producer) {
        this(Enricher.defaultAggregationStrategy(), producer);
    }

    public Enricher(AggregationStrategy aggregationStrategy, Producer producer) {
        this.aggregationStrategy = aggregationStrategy;
        this.producer = producer;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setDefaultAggregationStrategy() {
        this.aggregationStrategy = Enricher.defaultAggregationStrategy();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exchange resourceExchange = this.createResourceExchange(exchange, ExchangePattern.InOut);
        AsyncProcessor ap = AsyncProcessorConverterHelper.convert(this.producer);
        boolean sync = AsyncProcessorHelper.process(ap, resourceExchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                if (resourceExchange.isFailed()) {
                    ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
                } else {
                    Enricher.prepareResult(exchange);
                    ExchangeHelper.prepareAggregation(exchange, resourceExchange);
                    try {
                        Exchange aggregatedExchange = Enricher.this.aggregationStrategy.aggregate(exchange, resourceExchange);
                        if (aggregatedExchange != null) {
                            ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
                        }
                    }
                    catch (Throwable e) {
                        exchange.setException(new CamelExchangeException("Error occurred during aggregation", exchange, e));
                        callback.done(false);
                    }
                }
                if (exchange.hasOut()) {
                    exchange.getOut().setHeader("CamelToEndpoint", Enricher.this.producer.getEndpoint().getEndpointUri());
                } else {
                    exchange.getIn().setHeader("CamelToEndpoint", Enricher.this.producer.getEndpoint().getEndpointUri());
                }
                callback.done(false);
            }
        });
        if (!sync) {
            LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
            return false;
        }
        LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        if (resourceExchange.isFailed()) {
            ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
        } else {
            Exchange aggregatedExchange;
            Enricher.prepareResult(exchange);
            ExchangeHelper.prepareAggregation(exchange, resourceExchange);
            try {
                aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
            }
            catch (Throwable e) {
                exchange.setException(new CamelExchangeException("Error occurred during aggregation", exchange, e));
                callback.done(true);
                return true;
            }
            if (aggregatedExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
            }
        }
        if (exchange.hasOut()) {
            exchange.getOut().setHeader("CamelToEndpoint", this.producer.getEndpoint().getEndpointUri());
        } else {
            exchange.getIn().setHeader("CamelToEndpoint", this.producer.getEndpoint().getEndpointUri());
        }
        callback.done(true);
        return true;
    }

    protected Exchange createResourceExchange(Exchange source, ExchangePattern pattern) {
        Exchange target = source.copy();
        target.setPattern(pattern);
        return target;
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "Enrich[" + this.producer.getEndpoint() + "]";
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.producer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producer);
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        @Override
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(oldExchange, newExchange);
            }
            return oldExchange;
        }
    }
}

