/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Traceable;
import org.apache.camel.processor.ChildUnitOfWorkProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.AtomicException;
import org.apache.camel.util.concurrent.AtomicExchange;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable {
    private static final transient Logger LOG = LoggerFactory.getLogger(MulticastProcessor.class);
    protected final Processor onPrepare;
    private final CamelContext camelContext;
    private Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean parallelProcessing;
    private final boolean streaming;
    private final boolean stopOnException;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private ExecutorService aggregateExecutorService;
    private final long timeout;
    private final ConcurrentMap<PreparedErrorHandler, Processor> errorHandlers = new ConcurrentHashMap<PreparedErrorHandler, Processor>();
    private final boolean shareUnitOfWork;

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors) {
        this(camelContext, processors, null);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(camelContext, processors, aggregationStrategy, false, null, false, false, false, 0L, null, false);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork) {
        ObjectHelper.notNull(camelContext, "camelContext");
        this.camelContext = camelContext;
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.streaming = streaming;
        this.stopOnException = stopOnException;
        this.parallelProcessing = parallelProcessing || executorService != null;
        this.timeout = timeout;
        this.onPrepare = onPrepare;
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public String toString() {
        return "Multicast[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "multicast";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AtomicExchange result = new AtomicExchange();
        boolean exhaust = false;
        try {
            boolean sync = true;
            Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairs(exchange);
            boolean bl = exhaust = !this.isStreaming();
            if (this.isParallelProcessing()) {
                ObjectHelper.notNull(this.executorService, "executorService", this);
                this.doProcessParallel(exchange, result, pairs, this.isStreaming(), callback);
            } else {
                sync = this.doProcessSequential(exchange, result, pairs, callback);
            }
            if (!sync) {
                return false;
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            this.doDone(exchange, null, callback, true, exhaust);
            return true;
        }
        Exchange subExchange = result.get() != null ? (Exchange)result.get() : null;
        this.doDone(exchange, subExchange, callback, true, exhaust);
        return true;
    }

    protected void doProcessParallel(Exchange original, AtomicExchange result, Iterable<ProcessorExchangePair> pairs, boolean streaming, AsyncCallback callback) throws Exception {
        ObjectHelper.notNull(this.executorService, "ExecutorService", this);
        ObjectHelper.notNull(this.aggregateExecutorService, "AggregateExecutorService", this);
        CompletionService completion = streaming ? new ExecutorCompletionService(this.executorService) : new SubmitOrderedCompletionService(this.executorService);
        AtomicInteger total = new AtomicInteger(0);
        Iterator<ProcessorExchangePair> it = pairs.iterator();
        if (it.hasNext()) {
            final AtomicBoolean running = new AtomicBoolean(true);
            AtomicBoolean allTasksSubmitted = new AtomicBoolean();
            CountDownLatch aggregationOnTheFlyDone = new CountDownLatch(1);
            AtomicException executionException = new AtomicException();
            final AggregateOnTheFlyTask aggregateOnTheFlyTask = new AggregateOnTheFlyTask(result, original, total, completion, running, aggregationOnTheFlyDone, allTasksSubmitted, executionException);
            final AtomicBoolean aggregationTaskSubmitted = new AtomicBoolean();
            LOG.trace("Starting to submit parallel tasks");
            while (it.hasNext()) {
                final ProcessorExchangePair pair = it.next();
                final Exchange subExchange = pair.getExchange();
                this.updateNewExchange(subExchange, total.intValue(), pairs, it);
                completion.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        if (aggregationTaskSubmitted.compareAndSet(false, true)) {
                            MulticastProcessor.this.aggregateExecutorService.submit(aggregateOnTheFlyTask);
                        }
                        if (!running.get()) {
                            return subExchange;
                        }
                        try {
                            MulticastProcessor.this.doProcessParallel(pair);
                        }
                        catch (Throwable e) {
                            subExchange.setException(e);
                        }
                        Integer number = MulticastProcessor.this.getExchangeIndex(subExchange);
                        boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Parallel processing failed for number " + number, LOG);
                        if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                            running.set(false);
                            if (subExchange.getException() != null) {
                                throw new CamelExchangeException("Parallel processing failed for number " + number, subExchange, subExchange.getException());
                            }
                        }
                        LOG.trace("Parallel processing complete for exchange: {}", (Object)subExchange);
                        return subExchange;
                    }
                });
                total.incrementAndGet();
            }
            LOG.trace("Signaling that all {} tasks has been submitted.", (Object)total.get());
            allTasksSubmitted.set(true);
            LOG.debug("Waiting for on-the-fly aggregation to complete aggregating {} responses for exchangeId: {}", (Object)total.get(), (Object)original.getExchangeId());
            aggregationOnTheFlyDone.await();
            if (executionException.get() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parallel processing failed due {}", (Object)((Exception)executionException.get()).getMessage());
                }
                throw (Exception)executionException.get();
            }
        }
        LOG.debug("Done parallel processing {} exchanges", (Object)total);
    }

    protected boolean doProcessSequential(Exchange original, AtomicExchange result, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback) throws Exception {
        AtomicInteger total = new AtomicInteger();
        Iterator<ProcessorExchangePair> it = pairs.iterator();
        while (it.hasNext()) {
            ProcessorExchangePair pair = it.next();
            Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total.get(), pairs, it);
            boolean sync = this.doProcessSequential(original, result, pairs, it, pair, callback, total);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)pair.getExchange().getExchangeId());
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)pair.getExchange().getExchangeId());
            }
            boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Sequential processing failed for number " + total.get(), LOG);
            if (this.stopOnException && !continueProcessing) {
                if (subExchange.getException() != null) {
                    throw new CamelExchangeException("Sequential processing failed for number " + total.get(), subExchange, subExchange.getException());
                }
                result.set(subExchange);
                return true;
            }
            LOG.trace("Sequential processing complete for number {} exchange: {}", (Object)total, (Object)subExchange);
            this.doAggregate(this.getAggregationStrategy(subExchange), result, subExchange);
            total.incrementAndGet();
        }
        LOG.debug("Done sequential processing {} exchanges", (Object)total);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessSequential(final Exchange original, final AtomicExchange result, final Iterable<ProcessorExchangePair> pairs, final Iterator<ProcessorExchangePair> it, final ProcessorExchangePair pair, final AsyncCallback callback, final AtomicInteger total) {
        boolean sync = true;
        final Exchange exchange = pair.getExchange();
        Processor processor = pair.getProcessor();
        final Producer producer = pair.getProducer();
        TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
        final StopWatch watch = producer != null ? new StopWatch() : null;
        try {
            if (traced != null) {
                traced.pushBlock();
            }
            if (producer != null) {
                EventHelper.notifyExchangeSending(exchange.getContext(), exchange, producer.getEndpoint());
            }
            AsyncProcessor async = AsyncProcessorConverterHelper.convert(processor);
            pair.begin();
            sync = AsyncProcessorHelper.process(async, exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    pair.done();
                    if (producer != null) {
                        long timeTaken = watch.stop();
                        Endpoint endpoint = producer.getEndpoint();
                        EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
                    }
                    if (doneSync) {
                        return;
                    }
                    Exchange subExchange = exchange;
                    boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Sequential processing failed for number " + total.get(), LOG);
                    if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                        if (subExchange.getException() != null) {
                            subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException()));
                        } else {
                            result.set(subExchange);
                        }
                        MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                        return;
                    }
                    try {
                        MulticastProcessor.this.doAggregate(MulticastProcessor.this.getAggregationStrategy(subExchange), result, subExchange);
                    }
                    catch (Throwable e) {
                        subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, e));
                        MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                        return;
                    }
                    total.incrementAndGet();
                    while (it.hasNext()) {
                        ProcessorExchangePair pair2 = (ProcessorExchangePair)it.next();
                        subExchange = pair2.getExchange();
                        MulticastProcessor.this.updateNewExchange(subExchange, total.get(), pairs, it);
                        boolean sync = MulticastProcessor.this.doProcessSequential(original, result, pairs, it, pair2, callback, total);
                        if (!sync) {
                            LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)original.getExchangeId());
                            return;
                        }
                        continueProcessing = PipelineHelper.continueProcessing(subExchange, "Sequential processing failed for number " + total.get(), LOG);
                        if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                            if (subExchange.getException() != null) {
                                subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException()));
                            } else {
                                result.set(subExchange);
                            }
                            MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                            return;
                        }
                        try {
                            MulticastProcessor.this.doAggregate(MulticastProcessor.this.getAggregationStrategy(subExchange), result, subExchange);
                        }
                        catch (Throwable e) {
                            subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, e));
                            MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                            return;
                        }
                        total.incrementAndGet();
                    }
                    subExchange = result.get() != null ? (Exchange)result.get() : null;
                    MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                }
            });
        }
        finally {
            if (traced != null) {
                traced.popBlock();
            }
        }
        return sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessParallel(ProcessorExchangePair pair) throws Exception {
        Exchange exchange = pair.getExchange();
        Processor processor = pair.getProcessor();
        Producer producer = pair.getProducer();
        TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
        StopWatch watch = null;
        if (producer != null) {
            watch = new StopWatch();
        }
        try {
            if (traced != null) {
                traced.pushBlock();
            }
            if (producer != null) {
                EventHelper.notifyExchangeSending(exchange.getContext(), exchange, producer.getEndpoint());
            }
            AsyncProcessor async = AsyncProcessorConverterHelper.convert(processor);
            pair.begin();
            AsyncProcessorHelper.process(async, exchange);
        }
        finally {
            pair.done();
            if (traced != null) {
                traced.popBlock();
            }
            if (producer != null) {
                long timeTaken = watch.stop();
                Endpoint endpoint = producer.getEndpoint();
                EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
            }
        }
    }

    protected void doDone(Exchange original, Exchange subExchange, AsyncCallback callback, boolean doneSync, boolean exhaust) {
        this.removeAggregationStrategyFromExchange(original);
        if (original.getException() != null || subExchange != null && subExchange.getException() != null) {
            original.setProperty("CamelRedeliveryExhausted", exhaust);
        }
        if (subExchange != null) {
            ExchangeHelper.copyResults(original, subExchange);
        }
        callback.done(doneSync);
    }

    protected synchronized void doAggregate(AggregationStrategy strategy, AtomicExchange result, Exchange exchange) {
        if (strategy != null) {
            Exchange oldExchange = (Exchange)result.get();
            ExchangeHelper.prepareAggregation(oldExchange, exchange);
            result.set(strategy.aggregate(oldExchange, exchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, Iterator<ProcessorExchangePair> it) {
        exchange.setProperty("CamelMulticastIndex", index);
        if (it.hasNext()) {
            exchange.setProperty("CamelMulticastComplete", Boolean.FALSE);
        } else {
            exchange.setProperty("CamelMulticastComplete", Boolean.TRUE);
        }
    }

    protected Integer getExchangeIndex(Exchange exchange) {
        return exchange.getProperty("CamelMulticastIndex", Integer.class);
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        int index = 0;
        for (Processor processor : this.processors) {
            Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
            if (this.isShareUnitOfWork()) {
                this.prepareSharedUnitOfWork(copy, exchange);
            }
            RouteContext routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
            result.add(this.createProcessorExchangePair(index++, processor, copy, routeContext));
        }
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Processor processor, Exchange exchange, RouteContext routeContext) {
        Processor prepared = processor;
        MulticastProcessor.setToEndpoint(exchange, prepared);
        prepared = this.createErrorHandler(routeContext, exchange, prepared);
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
        }
        return new DefaultProcessorExchangePair(index, processor, prepared, exchange);
    }

    protected Processor createErrorHandler(RouteContext routeContext, Exchange exchange, Processor processor) {
        Processor answer;
        if (routeContext != null) {
            PreparedErrorHandler key = new PreparedErrorHandler(routeContext, processor);
            answer = (Processor)this.errorHandlers.get(key);
            if (answer != null) {
                LOG.trace("Using existing error handler for: {}", (Object)processor);
                return answer;
            }
            LOG.trace("Creating error handler for: {}", (Object)processor);
            ErrorHandlerFactory builder = routeContext.getRoute().getErrorHandlerBuilder();
            try {
                processor = builder.createErrorHandler(routeContext, processor);
                answer = this.createUnitOfWorkProcessor(routeContext, processor, exchange);
                ServiceHelper.startServices(answer);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            this.errorHandlers.putIfAbsent(key, answer);
        } else {
            answer = this.createUnitOfWorkProcessor(routeContext, processor, exchange);
        }
        return answer;
    }

    protected UnitOfWorkProcessor createUnitOfWorkProcessor(RouteContext routeContext, Processor processor, Exchange exchange) {
        UnitOfWork parent = exchange.getProperty("CamelParentUnitOfWork", UnitOfWork.class);
        if (parent != null) {
            return new ChildUnitOfWorkProcessor(parent, routeContext, processor);
        }
        return new UnitOfWorkProcessor(routeContext, processor);
    }

    protected void prepareSharedUnitOfWork(Exchange childExchange, Exchange parentExchange) {
        childExchange.setProperty("CamelParentUnitOfWork", parentExchange.getUnitOfWork());
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isParallelProcessing() && this.executorService == null) {
            throw new IllegalArgumentException("ParallelProcessing is enabled but ExecutorService has not been set");
        }
        if (this.timeout > 0L && !this.isParallelProcessing()) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled");
        }
        if (this.isParallelProcessing() && this.aggregateExecutorService == null) {
            String name = this.getClass().getSimpleName() + "-AggregateTask";
            this.aggregateExecutorService = this.createAggregateExecutorService(name);
        }
        ServiceHelper.startServices(this.processors);
    }

    protected synchronized ExecutorService createAggregateExecutorService(String name) {
        return this.camelContext.getExecutorServiceManager().newCachedThreadPool(this, name);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processors, this.errorHandlers);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.processors, this.errorHandlers);
        this.errorHandlers.clear();
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
        if (this.aggregateExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.aggregateExecutorService);
        }
    }

    protected static void setToEndpoint(Exchange exchange, Processor processor) {
        if (processor instanceof Producer) {
            Producer producer = (Producer)processor;
            exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
        }
    }

    protected AggregationStrategy getAggregationStrategy(Exchange exchange) {
        Map property;
        Map map;
        AggregationStrategy answer = null;
        if (exchange != null && (map = CastUtils.cast(property = exchange.getProperty("CamelAggregationStrategy", Map.class))) != null) {
            answer = (AggregationStrategy)map.get(this);
        }
        if (answer == null) {
            answer = this.getAggregationStrategy();
        }
        return answer;
    }

    protected void setAggregationStrategyOnExchange(Exchange exchange, AggregationStrategy aggregationStrategy) {
        Map property = exchange.getProperty("CamelAggregationStrategy", Map.class);
        Map map = CastUtils.cast(property);
        if (map == null) {
            map = new HashMap();
        }
        map.put(this, aggregationStrategy);
        exchange.setProperty("CamelAggregationStrategy", map);
    }

    protected void removeAggregationStrategyFromExchange(Exchange exchange) {
        Map property = exchange.getProperty("CamelAggregationStrategy", Map.class);
        Map map = CastUtils.cast(property);
        if (map == null) {
            return;
        }
        map.remove(this);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    @Override
    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    private final class AggregateOnTheFlyTask
    implements Runnable {
        private final AtomicExchange result;
        private final Exchange original;
        private final AtomicInteger total;
        private final CompletionService<Exchange> completion;
        private final AtomicBoolean running;
        private final CountDownLatch aggregationOnTheFlyDone;
        private final AtomicBoolean allTasksSubmitted;
        private final AtomicException executionException;

        private AggregateOnTheFlyTask(AtomicExchange result, Exchange original, AtomicInteger total, CompletionService<Exchange> completion, AtomicBoolean running, CountDownLatch aggregationOnTheFlyDone, AtomicBoolean allTasksSubmitted, AtomicException executionException) {
            this.result = result;
            this.original = original;
            this.total = total;
            this.completion = completion;
            this.running = running;
            this.aggregationOnTheFlyDone = aggregationOnTheFlyDone;
            this.allTasksSubmitted = allTasksSubmitted;
            this.executionException = executionException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.trace("Aggregate on the fly task started for exchangeId: {}", (Object)this.original.getExchangeId());
            try {
                this.aggregateOnTheFly();
            }
            catch (Throwable e) {
                if (e instanceof Exception) {
                    this.executionException.set((Exception)e);
                } else {
                    this.executionException.set(ObjectHelper.wrapRuntimeCamelException(e));
                }
            }
            finally {
                LOG.debug("Signaling we are done aggregating on the fly for exchangeId: {}", (Object)this.original.getExchangeId());
                LOG.trace("Aggregate on the fly task done for exchangeId: {}", (Object)this.original.getExchangeId());
                this.aggregationOnTheFlyDone.countDown();
            }
        }

        private void aggregateOnTheFly() throws InterruptedException, ExecutionException {
            boolean timedOut = false;
            boolean stoppedOnException = false;
            StopWatch watch = new StopWatch();
            int aggregated = 0;
            boolean done = false;
            while (!done) {
                Future<Exchange> future;
                if (this.allTasksSubmitted.get() && aggregated >= this.total.get()) {
                    LOG.debug("Done aggregating {} exchanges on the fly.", (Object)aggregated);
                    break;
                }
                if (timedOut) {
                    future = this.completion.poll();
                    LOG.trace("Polled completion task #{} after timeout to grab already completed tasks: {}", (Object)aggregated, future);
                } else if (MulticastProcessor.this.timeout > 0L) {
                    long left = MulticastProcessor.this.timeout - watch.taken();
                    if (left < 0L) {
                        left = 0L;
                    }
                    LOG.trace("Polling completion task #{} using timeout {} millis.", (Object)aggregated, (Object)left);
                    future = this.completion.poll(left, TimeUnit.MILLISECONDS);
                } else {
                    LOG.trace("Polling completion task #{}", (Object)aggregated);
                    future = this.completion.poll(1L, TimeUnit.SECONDS);
                    if (future == null) continue;
                }
                if (future == null && timedOut) break;
                if (future == null) {
                    AggregationStrategy strategy = MulticastProcessor.this.getAggregationStrategy(null);
                    if (strategy instanceof TimeoutAwareAggregationStrategy) {
                        Exchange oldExchange = (Exchange)this.result.get();
                        if (oldExchange == null) {
                            oldExchange = this.original;
                        }
                        ((TimeoutAwareAggregationStrategy)strategy).timeout(oldExchange, aggregated, this.total.intValue(), MulticastProcessor.this.timeout);
                    } else {
                        LOG.warn("Parallel processing timed out after {} millis for number {}. This task will be cancelled and will not be aggregated.", (Object)MulticastProcessor.this.timeout, (Object)aggregated);
                    }
                    LOG.debug("Timeout occurred after {} millis for number {} task.", (Object)MulticastProcessor.this.timeout, (Object)aggregated);
                    timedOut = true;
                    if (this.completion instanceof SubmitOrderedCompletionService) {
                        ((SubmitOrderedCompletionService)this.completion).timeoutTask();
                    }
                } else {
                    Exchange subExchange = future.get();
                    Integer number = MulticastProcessor.this.getExchangeIndex(subExchange);
                    boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Parallel processing failed for number " + number, LOG);
                    if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                        this.result.set(subExchange);
                        stoppedOnException = true;
                        break;
                    }
                    AggregationStrategy strategy = MulticastProcessor.this.getAggregationStrategy(subExchange);
                    MulticastProcessor.this.doAggregate(strategy, this.result, subExchange);
                }
                ++aggregated;
            }
            if (timedOut || stoppedOnException) {
                if (timedOut) {
                    LOG.debug("Cancelling tasks due timeout after {} millis.", (Object)MulticastProcessor.this.timeout);
                }
                if (stoppedOnException) {
                    LOG.debug("Cancelling tasks due stopOnException.");
                }
                this.running.set(false);
            }
        }
    }

    static final class PreparedErrorHandler
    extends KeyValueHolder<RouteContext, Processor> {
        public PreparedErrorHandler(RouteContext key, Processor value) {
            super(key, value);
        }
    }

    static final class DefaultProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Processor processor;
        private final Processor prepared;
        private final Exchange exchange;

        private DefaultProcessorExchangePair(int index, Processor processor, Processor prepared, Exchange exchange) {
            this.index = index;
            this.processor = processor;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public Producer getProducer() {
            if (this.processor instanceof Producer) {
                return (Producer)this.processor;
            }
            return null;
        }

        @Override
        public Processor getProcessor() {
            return this.prepared;
        }

        @Override
        public void begin() {
        }

        @Override
        public void done() {
        }
    }
}

