/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.main;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.basic.DefaultActionPreparator;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.admin.command.AdminCommandSupport;
import org.apache.karaf.admin.command.ChangeRmiRegistryPortCommand;
import org.apache.karaf.admin.command.ChangeRmiServerPortCommand;
import org.apache.karaf.admin.command.ChangeSshPortCommand;
import org.apache.karaf.admin.command.CreateCommand;
import org.apache.karaf.admin.command.DestroyCommand;
import org.apache.karaf.admin.command.ListCommand;
import org.apache.karaf.admin.command.StartCommand;
import org.apache.karaf.admin.command.StopCommand;
import org.apache.karaf.admin.internal.AdminServiceImpl;
import org.fusesource.jansi.AnsiConsole;

public class Execute {
    static Class<? extends Action> x = CreateCommand.class;
    private static final Class<?>[] COMMAND_CLASSES = new Class[]{CreateCommand.class, StartCommand.class, StopCommand.class, DestroyCommand.class, ListCommand.class, ChangeSshPortCommand.class, ChangeRmiRegistryPortCommand.class, ChangeRmiServerPortCommand.class};
    private static final Map<String, Class<?>> COMMANDS = new TreeMap();
    static boolean exitAllowed;
    private static final String ENV_KARAF_OPTS = "KARAF_OPTS";
    private static final String PROP_KARAF_OPTS = "karaf.opts";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        File storageFile;
        String commandName;
        Class<?> cls;
        block10: {
            String storage;
            AnsiConsole.systemInstall();
            if (args.length == 0) {
                Execute.listCommands();
                Execute.exit(0);
            }
            if ((cls = COMMANDS.get(commandName = args[0])) == null) {
                System.err.println("Command not found: " + commandName);
                Execute.exit(-1);
            }
            if ((storage = System.getProperty("karaf.instances")) == null) {
                System.err.println("System property 'karaf.instances' is not set. \nThis property needs to be set to the full path of the instance.properties file.");
                Execute.exit(-1);
            }
            storageFile = new File(storage);
            System.setProperty("user.dir", storageFile.getParentFile().getParentFile().getCanonicalPath());
            try {
                String karafOpts = System.getenv(ENV_KARAF_OPTS);
                if (karafOpts != null) {
                    System.setProperty(PROP_KARAF_OPTS, karafOpts);
                }
            }
            catch (Exception e) {
                System.err.println("Could not read KARAF_OPTS environment variable: " + e.getMessage());
                if (System.getProperty("karaf.showStackTrace") == null) break block10;
                throw e;
            }
        }
        Object command = cls.newInstance();
        if (command instanceof AdminCommandSupport) {
            try {
                Execute.execute((AdminCommandSupport)((Object)command), storageFile, args);
                return;
            }
            catch (Exception e) {
                System.err.println("Error execution command '" + commandName + "': " + e.getMessage());
                if (System.getProperty("karaf.showStackTrace") == null) return;
                throw e;
            }
        } else {
            System.err.println("Not an admin command: " + commandName);
            Execute.exit(-1);
        }
    }

    static void execute(AdminCommandSupport command, File storageFile, String[] args) throws Exception {
        DefaultActionPreparator dap = new DefaultActionPreparator();
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(args));
        params.remove(0);
        if (!dap.prepare((Action)command, null, params)) {
            return;
        }
        AdminServiceImpl admin = new AdminServiceImpl();
        admin.setStorageLocation(storageFile);
        admin.init();
        command.setAdminService((AdminService)admin);
        command.execute(null);
    }

    private static void listCommands() {
        System.out.println("Available commands:");
        for (Map.Entry<String, Class<?>> entry : COMMANDS.entrySet()) {
            Command ann = entry.getValue().getAnnotation(Command.class);
            System.out.printf("  %s - %s\n", entry.getKey(), ann.description());
        }
        System.out.println("Type 'command --help' for more help on the specified command.");
    }

    private static void exit(int rc) {
        if (!exitAllowed) {
            throw new RuntimeException("" + rc);
        }
        System.exit(rc);
    }

    static {
        for (Class<?> c : COMMAND_CLASSES) {
            Command ann = c.getAnnotation(Command.class);
            if (ann == null) continue;
            COMMANDS.put(ann.name(), c);
        }
        exitAllowed = true;
    }
}

