/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.CompoundWordTokenFilterBase;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.util.Version;

public class DictionaryCompoundWordTokenFilter
extends CompoundWordTokenFilterBase {
    @Deprecated
    public DictionaryCompoundWordTokenFilter(TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(Version.LUCENE_30, input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    @Deprecated
    public DictionaryCompoundWordTokenFilter(TokenStream input, String[] dictionary) {
        super(Version.LUCENE_30, input, dictionary);
    }

    @Deprecated
    public DictionaryCompoundWordTokenFilter(TokenStream input, Set dictionary) {
        super(Version.LUCENE_30, input, dictionary);
    }

    @Deprecated
    public DictionaryCompoundWordTokenFilter(TokenStream input, Set dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(Version.LUCENE_30, input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    public DictionaryCompoundWordTokenFilter(Version matchVersion, TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(matchVersion, input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    public DictionaryCompoundWordTokenFilter(Version matchVersion, TokenStream input, String[] dictionary) {
        super(matchVersion, input, dictionary);
    }

    public DictionaryCompoundWordTokenFilter(Version matchVersion, TokenStream input, Set dictionary) {
        super(matchVersion, input, dictionary);
    }

    public DictionaryCompoundWordTokenFilter(Version matchVersion, TokenStream input, Set dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(matchVersion, input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    protected void decomposeInternal(Token token) {
        if (token.length() < this.minWordSize) {
            return;
        }
        char[] lowerCaseTermBuffer = DictionaryCompoundWordTokenFilter.makeLowerCaseCopy(token.buffer());
        for (int i = 0; i < token.length() - this.minSubwordSize; ++i) {
            CharTermAttributeImpl longestMatchToken = null;
            for (int j = this.minSubwordSize - 1; j < this.maxSubwordSize && i + j <= token.length(); ++j) {
                if (!this.dictionary.contains(lowerCaseTermBuffer, i, j)) continue;
                if (this.onlyLongestMatch) {
                    if (longestMatchToken != null) {
                        if (longestMatchToken.length() >= j) continue;
                        longestMatchToken = this.createToken(i, j, token);
                        continue;
                    }
                    longestMatchToken = this.createToken(i, j, token);
                    continue;
                }
                this.tokens.add(this.createToken(i, j, token));
            }
            if (!this.onlyLongestMatch || longestMatchToken == null) continue;
            this.tokens.add(longestMatchToken);
        }
    }
}

