/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.TermSpans;

public class AllTermQuery
extends SpanTermQuery {
    private boolean includeSpanScore;

    public AllTermQuery(Term term) {
        this(term, true);
    }

    public AllTermQuery(Term term, boolean includeSpanScore) {
        super(term);
        this.includeSpanScore = includeSpanScore;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new AllTermWeight(this, searcher);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.includeSpanScore ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllTermQuery other = (AllTermQuery)obj;
        return this.includeSpanScore == other.includeSpanScore;
    }

    protected class AllTermWeight
    extends SpanWeight {
        public AllTermWeight(AllTermQuery query, Searcher searcher) throws IOException {
            super(query, searcher);
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new AllTermSpanScorer((TermSpans)this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
        }

        protected class AllTermSpanScorer
        extends SpanScorer {
            protected byte[] payload;
            protected TermPositions positions;
            protected float payloadScore;
            protected int payloadsSeen;

            public AllTermSpanScorer(TermSpans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
                super(spans, weight, similarity, norms);
                this.payload = new byte[4];
                this.positions = spans.getPositions();
            }

            @Override
            protected boolean setFreqCurrentDoc() throws IOException {
                if (!this.more) {
                    return false;
                }
                this.doc = this.spans.doc();
                this.freq = 0.0f;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                Similarity similarity1 = this.getSimilarity();
                while (this.more && this.doc == this.spans.doc()) {
                    int matchLength = this.spans.end() - this.spans.start();
                    this.freq += similarity1.sloppyFreq(matchLength);
                    this.processPayload(similarity1);
                    this.more = this.spans.next();
                }
                return this.more || this.freq != 0.0f;
            }

            protected void processPayload(Similarity similarity) throws IOException {
                if (this.positions.isPayloadAvailable()) {
                    this.payload = this.positions.getPayload(this.payload, 0);
                    this.payloadScore += PayloadHelper.decodeFloat(this.payload);
                    ++this.payloadsSeen;
                }
            }

            @Override
            public float score() throws IOException {
                return AllTermQuery.this.includeSpanScore ? this.getSpanScore() * this.getPayloadScore() : this.getPayloadScore();
            }

            protected float getSpanScore() throws IOException {
                return super.score();
            }

            protected float getPayloadScore() {
                return this.payloadsSeen > 0 ? this.payloadScore / (float)this.payloadsSeen : 1.0f;
            }

            @Override
            protected Explanation explain(int doc) throws IOException {
                ComplexExplanation result = new ComplexExplanation();
                Explanation nonPayloadExpl = super.explain(doc);
                result.addDetail(nonPayloadExpl);
                Explanation payloadBoost = new Explanation();
                result.addDetail(payloadBoost);
                float payloadScore = this.getPayloadScore();
                payloadBoost.setValue(payloadScore);
                payloadBoost.setDescription("allPayload(...)");
                result.setValue(nonPayloadExpl.getValue() * payloadScore);
                result.setDescription("btq, product of:");
                result.setMatch(nonPayloadExpl.getValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE);
                return result;
            }
        }
    }
}

