/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class ZooKeeperUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    private ServiceTracker tracker = new ServiceTracker(this.context, IZKClient.class.getName(), null);

    public ZooKeeperUnicastHostsProvider(Settings settings) {
        super(settings);
        this.tracker.open();
    }

    @Override
    public List<DiscoveryNode> buildDynamicNodes() {
        try {
            ArrayList<DiscoveryNode> dn = new ArrayList<DiscoveryNode>();
            IZKClient zooKeeper = (IZKClient)this.tracker.getService();
            if (zooKeeper != null && zooKeeper.isConnected()) {
                String path = this.componentSettings.get("node");
                List nodes = zooKeeper.getChildren(path);
                for (String node : nodes) {
                    String data = zooKeeper.getStringData(path + "/" + node);
                    String[] datas = data.split(":");
                    InetSocketTransportAddress addr = new InetSocketTransportAddress(datas[0], Integer.parseInt(datas[1]));
                    dn.add(new DiscoveryNode(node, addr));
                }
            }
            return dn;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

