/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class ArabicAnalyzerProvider
extends AbstractIndexAnalyzerProvider<ArabicAnalyzer> {
    private final ArabicAnalyzer arabicAnalyzer;

    @Inject
    public ArabicAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Set<?> stopWords = Analysis.parseStopWords(settings, ArabicAnalyzer.getDefaultStopSet());
        this.arabicAnalyzer = new ArabicAnalyzer(this.version, stopWords);
    }

    @Override
    public ArabicAnalyzer get() {
        return this.arabicAnalyzer;
    }
}

