/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class StandardAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StandardAnalyzer> {
    private final StandardAnalyzer standardAnalyzer;

    @Inject
    public StandardAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Set<?> stopWords = Analysis.parseStopWords(settings, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        int maxTokenLength = settings.getAsInt("max_token_length", 255);
        this.standardAnalyzer = new StandardAnalyzer(this.version, stopWords);
        this.standardAnalyzer.setMaxTokenLength(maxTokenLength);
    }

    @Override
    public StandardAnalyzer get() {
        return this.standardAnalyzer;
    }
}

