/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.compound;

import java.io.File;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.compound.AbstractCompoundWordTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class HyphenationCompoundWordTokenFilterFactory
extends AbstractCompoundWordTokenFilterFactory {
    private final HyphenationTree hyphenationTree;

    @Inject
    public HyphenationCompoundWordTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String hyphenationPatternsPath = settings.get("hyphenation_patterns_path", null);
        if (hyphenationPatternsPath == null) {
            throw new ElasticSearchIllegalArgumentException("hyphenation_patterns_path is a required setting.");
        }
        File hyphenationPatternsFile = new File(hyphenationPatternsPath);
        if (!hyphenationPatternsFile.exists()) {
            throw new ElasticSearchIllegalArgumentException("hyphenation_patterns_path file must exist.");
        }
        try {
            this.hyphenationTree = HyphenationCompoundWordTokenFilter.getHyphenationTree(hyphenationPatternsFile);
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalArgumentException("Exception while reading hyphenation_patterns_path: " + e.getMessage());
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HyphenationCompoundWordTokenFilter(this.version, tokenStream, this.hyphenationTree, this.wordList, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

