/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.search.PublicTermsFilter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadSafe;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.FailedToResolveConfigException;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.xcontent.XContentDocumentMapperParser;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;

@ThreadSafe
public class MapperService
extends AbstractIndexComponent
implements Iterable<DocumentMapper> {
    public static final String DEFAULT_MAPPING = "_default_";
    private final boolean dynamic;
    private volatile String defaultMappingSource;
    private volatile ImmutableMap<String, DocumentMapper> mappers = ImmutableMap.of();
    private final Object mutex = new Object();
    private volatile ImmutableMap<String, FieldMappers> nameFieldMappers = ImmutableMap.of();
    private volatile ImmutableMap<String, FieldMappers> indexNameFieldMappers = ImmutableMap.of();
    private volatile ImmutableMap<String, FieldMappers> fullNameFieldMappers = ImmutableMap.of();
    private final DocumentMapperParser documentParser;
    private final InternalFieldMapperListener fieldMapperListener = new InternalFieldMapperListener();
    private final SmartIndexNameSearchAnalyzer searchAnalyzer;

    @Inject
    public MapperService(Index index, @IndexSettings Settings indexSettings, Environment environment, AnalysisService analysisService) {
        super(index, indexSettings);
        URL defaultMappingUrl;
        this.documentParser = new XContentDocumentMapperParser(index, indexSettings, analysisService);
        this.searchAnalyzer = new SmartIndexNameSearchAnalyzer(analysisService.defaultSearchAnalyzer());
        this.dynamic = this.componentSettings.getAsBoolean("dynamic", true);
        String defaultMappingLocation = this.componentSettings.get("default_mapping_location");
        if (defaultMappingLocation == null) {
            try {
                defaultMappingUrl = environment.resolveConfig("default-mapping.json");
            }
            catch (FailedToResolveConfigException e) {
                defaultMappingUrl = indexSettings.getClassLoader().getResource("org/elasticsearch/index/mapper/xcontent/default-mapping.json");
            }
        } else {
            try {
                defaultMappingUrl = environment.resolveConfig(defaultMappingLocation);
            }
            catch (FailedToResolveConfigException e) {
                try {
                    defaultMappingUrl = new File(defaultMappingLocation).toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    throw new FailedToResolveConfigException("Failed to resolve dynamic mapping location [" + defaultMappingLocation + "]");
                }
            }
        }
        try {
            this.defaultMappingSource = Streams.copyToString(new InputStreamReader(defaultMappingUrl.openStream(), "UTF-8"));
        }
        catch (IOException e) {
            throw new MapperException("Failed to load default mapping source from [" + defaultMappingLocation + "]", e);
        }
        this.logger.debug("using dynamic[{}], default mapping: location[{}] and source[{}]", this.dynamic, defaultMappingLocation, this.defaultMappingSource);
    }

    public void close() {
        for (DocumentMapper documentMapper : this.mappers.values()) {
            documentMapper.close();
        }
    }

    @Override
    public UnmodifiableIterator<DocumentMapper> iterator() {
        return ((ImmutableCollection)this.mappers.values()).iterator();
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String type, String mappingSource) {
        if (DEFAULT_MAPPING.equals(type)) {
            DocumentMapper mapper = this.documentParser.parse(type, mappingSource);
            Object object = this.mutex;
            synchronized (object) {
                this.mappers = MapBuilder.newMapBuilder(this.mappers).put(type, mapper).immutableMap();
            }
            this.defaultMappingSource = mappingSource;
        } else {
            this.add(this.parse(type, mappingSource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(DocumentMapper mapper) {
        Object object = this.mutex;
        synchronized (object) {
            if (mapper.type().charAt(0) == '_') {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] can't start with '_'");
            }
            if (mapper.type().contains("#")) {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include '#' in it");
            }
            if (mapper.type().contains(".")) {
                this.logger.warn("Type [{}] contains a '.', it is recommended not to include it within a type name", mapper.type());
            }
            this.remove(mapper.type());
            this.mappers = MapBuilder.newMapBuilder(this.mappers).put(mapper.type(), mapper).immutableMap();
            mapper.addFieldMapperListener(this.fieldMapperListener, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String type) {
        Object object = this.mutex;
        synchronized (object) {
            DocumentMapper docMapper = this.mappers.get(type);
            if (docMapper == null) {
                return;
            }
            docMapper.close();
            this.mappers = MapBuilder.newMapBuilder(this.mappers).remove(type).immutableMap();
            for (FieldMapper mapper : docMapper.mappers()) {
                FieldMappers mappers = this.nameFieldMappers.get(mapper.names().name());
                if (mappers != null) {
                    this.nameFieldMappers = (mappers = mappers.remove(mapper)).isEmpty() ? MapBuilder.newMapBuilder(this.nameFieldMappers).remove(mapper.names().name()).immutableMap() : MapBuilder.newMapBuilder(this.nameFieldMappers).put(mapper.names().name(), mappers).immutableMap();
                }
                if ((mappers = this.indexNameFieldMappers.get(mapper.names().indexName())) != null) {
                    this.indexNameFieldMappers = (mappers = mappers.remove(mapper)).isEmpty() ? MapBuilder.newMapBuilder(this.indexNameFieldMappers).remove(mapper.names().indexName()).immutableMap() : MapBuilder.newMapBuilder(this.indexNameFieldMappers).put(mapper.names().indexName(), mappers).immutableMap();
                }
                if ((mappers = this.fullNameFieldMappers.get(mapper.names().fullName())) == null) continue;
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    this.fullNameFieldMappers = MapBuilder.newMapBuilder(this.fullNameFieldMappers).remove(mapper.names().fullName()).immutableMap();
                    continue;
                }
                this.fullNameFieldMappers = MapBuilder.newMapBuilder(this.fullNameFieldMappers).put(mapper.names().fullName(), mappers).immutableMap();
            }
        }
    }

    public DocumentMapper parse(String mappingType, String mappingSource) throws MapperParsingException {
        return this.documentParser.parse(mappingType, mappingSource, this.defaultMappingSource);
    }

    public boolean hasMapping(String mappingType) {
        return this.mappers.containsKey(mappingType);
    }

    public DocumentMapper documentMapper(String type) {
        return this.mappers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMapper documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.mappers.get(type);
        if (mapper != null) {
            return mapper;
        }
        if (!this.dynamic) {
            throw new TypeMissingException(this.index, type, "typing to auto create mapping, but dynamic mapping is disabled");
        }
        Object object = this.mutex;
        synchronized (object) {
            mapper = this.mappers.get(type);
            if (mapper != null) {
                return mapper;
            }
            this.add(type, null);
            return this.mappers.get(type);
        }
    }

    public Filter typesFilter(String ... types) {
        if (types.length == 1) {
            DocumentMapper docMapper = this.documentMapper(types[0]);
            if (docMapper == null) {
                return new TermFilter(new Term(types[0]));
            }
            return docMapper.typeFilter();
        }
        boolean useTermsFilter = true;
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                useTermsFilter = false;
                break;
            }
            if (docMapper.typeMapper().indexed()) continue;
            useTermsFilter = false;
            break;
        }
        if (useTermsFilter) {
            PublicTermsFilter termsFilter = new PublicTermsFilter();
            for (String type : types) {
                termsFilter.addTerm(new Term("_type", type));
            }
            return termsFilter;
        }
        XBooleanFilter bool = new XBooleanFilter();
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                bool.add(new FilterClause(new TermFilter(new Term("_type", type)), BooleanClause.Occur.SHOULD));
                continue;
            }
            bool.add(new FilterClause(docMapper.typeFilter(), BooleanClause.Occur.SHOULD));
        }
        return bool;
    }

    public Filter typesFilterFailOnMissing(String ... types) throws TypeMissingException {
        if (types.length == 1) {
            DocumentMapper docMapper = this.documentMapper(types[0]);
            if (docMapper == null) {
                throw new TypeMissingException(this.index, types[0]);
            }
            return docMapper.typeFilter();
        }
        PublicTermsFilter termsFilter = new PublicTermsFilter();
        for (String type : types) {
            if (!this.hasMapping(type)) {
                throw new TypeMissingException(this.index, type);
            }
            termsFilter.addTerm(new Term("_type", type));
        }
        return termsFilter;
    }

    public FieldMappers name(String name) {
        return this.nameFieldMappers.get(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.indexNameFieldMappers.get(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fullNameFieldMappers.get(fullName);
    }

    public FieldMapper smartNameFieldMapper(String smartName) {
        FieldMappers fieldMappers = this.smartNameFieldMappers(smartName);
        if (fieldMappers != null) {
            return fieldMappers.mapper();
        }
        return null;
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        String possibleType;
        DocumentMapper possibleDocMapper;
        int dotIndex = pattern.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = pattern.substring(0, dotIndex))) != null) {
            HashSet<String> typedFields = Sets.newHashSet();
            for (String indexName : possibleDocMapper.mappers().simpleMatchToIndexNames(pattern)) {
                typedFields.add(possibleType + "." + indexName);
            }
            return typedFields;
        }
        HashSet<String> fields = Sets.newHashSet();
        for (Map.Entry entry : this.fullNameFieldMappers.entrySet()) {
            if (!Regex.simpleMatch(pattern, (String)entry.getKey())) continue;
            for (FieldMapper mapper : (FieldMappers)entry.getValue()) {
                fields.add(mapper.names().indexName());
            }
        }
        for (Map.Entry entry : this.indexNameFieldMappers.entrySet()) {
            if (!Regex.simpleMatch(pattern, (String)entry.getKey())) continue;
            for (FieldMapper mapper : (FieldMappers)entry.getValue()) {
                fields.add(mapper.names().indexName());
            }
        }
        for (Map.Entry entry : this.nameFieldMappers.entrySet()) {
            if (!Regex.simpleMatch(pattern, (String)entry.getKey())) continue;
            for (FieldMapper mapper : (FieldMappers)entry.getValue()) {
                fields.add(mapper.names().indexName());
            }
        }
        return fields;
    }

    public FieldMappers smartNameFieldMappers(String smartName) {
        FieldMappers mappers;
        String possibleType;
        DocumentMapper possibleDocMapper;
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possibleName = smartName.substring(dotIndex + 1);
            FieldMappers mappers2 = possibleDocMapper.mappers().smartName(possibleName);
            if (mappers2 != null) {
                return mappers2;
            }
        }
        if ((mappers = this.fullName(smartName)) != null) {
            return mappers;
        }
        mappers = this.indexName(smartName);
        if (mappers != null) {
            return mappers;
        }
        return this.name(smartName);
    }

    public SmartNameFieldMappers smartName(String smartName) {
        FieldMappers fieldMappers;
        String possibleType;
        DocumentMapper possibleDocMapper;
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possibleName = smartName.substring(dotIndex + 1);
            FieldMappers mappers = possibleDocMapper.mappers().smartName(possibleName);
            if (mappers != null) {
                return new SmartNameFieldMappers(mappers, possibleDocMapper);
            }
        }
        if ((fieldMappers = this.fullName(smartName)) != null) {
            return new SmartNameFieldMappers(fieldMappers, null);
        }
        fieldMappers = this.indexName(smartName);
        if (fieldMappers != null) {
            return new SmartNameFieldMappers(fieldMappers, null);
        }
        fieldMappers = this.name(smartName);
        if (fieldMappers != null) {
            return new SmartNameFieldMappers(fieldMappers, null);
        }
        return null;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    private class InternalFieldMapperListener
    implements FieldMapperListener {
        private InternalFieldMapperListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fieldMapper(FieldMapper fieldMapper) {
            Object object = MapperService.this.mutex;
            synchronized (object) {
                FieldMappers mappers = (FieldMappers)MapperService.this.nameFieldMappers.get(fieldMapper.names().name());
                mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
                MapperService.this.nameFieldMappers = MapBuilder.newMapBuilder(MapperService.this.nameFieldMappers).put(fieldMapper.names().name(), mappers).immutableMap();
                mappers = (FieldMappers)MapperService.this.indexNameFieldMappers.get(fieldMapper.names().indexName());
                mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
                MapperService.this.indexNameFieldMappers = MapBuilder.newMapBuilder(MapperService.this.indexNameFieldMappers).put(fieldMapper.names().indexName(), mappers).immutableMap();
                mappers = (FieldMappers)MapperService.this.fullNameFieldMappers.get(fieldMapper.names().fullName());
                mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
                MapperService.this.fullNameFieldMappers = MapBuilder.newMapBuilder(MapperService.this.fullNameFieldMappers).put(fieldMapper.names().fullName(), mappers).immutableMap();
            }
        }
    }

    final class SmartIndexNameSearchAnalyzer
    extends Analyzer {
        private final Analyzer defaultAnalyzer;

        SmartIndexNameSearchAnalyzer(Analyzer defaultAnalyzer) {
            this.defaultAnalyzer = defaultAnalyzer;
        }

        @Override
        public int getPositionIncrementGap(String fieldName) {
            FieldMappers mappers;
            int dotIndex = fieldName.indexOf(46);
            if (dotIndex != -1) {
                String possibleType = fieldName.substring(0, dotIndex);
                DocumentMapper possibleDocMapper = (DocumentMapper)MapperService.this.mappers.get(possibleType);
                if (possibleDocMapper != null) {
                    return possibleDocMapper.mappers().searchAnalyzer().getPositionIncrementGap(fieldName);
                }
            }
            if ((mappers = (FieldMappers)MapperService.this.fullNameFieldMappers.get(fieldName)) != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().getPositionIncrementGap(fieldName);
            }
            mappers = (FieldMappers)MapperService.this.indexNameFieldMappers.get(fieldName);
            if (mappers != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().getPositionIncrementGap(fieldName);
            }
            return this.defaultAnalyzer.getPositionIncrementGap(fieldName);
        }

        @Override
        public int getOffsetGap(Fieldable field) {
            FieldMappers mappers;
            String fieldName = field.name();
            int dotIndex = fieldName.indexOf(46);
            if (dotIndex != -1) {
                String possibleType = fieldName.substring(0, dotIndex);
                DocumentMapper possibleDocMapper = (DocumentMapper)MapperService.this.mappers.get(possibleType);
                if (possibleDocMapper != null) {
                    return possibleDocMapper.mappers().searchAnalyzer().getOffsetGap(field);
                }
            }
            if ((mappers = (FieldMappers)MapperService.this.fullNameFieldMappers.get(fieldName)) != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().getOffsetGap(field);
            }
            mappers = (FieldMappers)MapperService.this.indexNameFieldMappers.get(fieldName);
            if (mappers != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().getOffsetGap(field);
            }
            return this.defaultAnalyzer.getOffsetGap(field);
        }

        @Override
        public final TokenStream tokenStream(String fieldName, Reader reader) {
            FieldMappers mappers;
            int dotIndex = fieldName.indexOf(46);
            if (dotIndex != -1) {
                String possibleType = fieldName.substring(0, dotIndex);
                DocumentMapper possibleDocMapper = (DocumentMapper)MapperService.this.mappers.get(possibleType);
                if (possibleDocMapper != null) {
                    return possibleDocMapper.mappers().searchAnalyzer().tokenStream(fieldName, reader);
                }
            }
            if ((mappers = (FieldMappers)MapperService.this.fullNameFieldMappers.get(fieldName)) != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().tokenStream(fieldName, reader);
            }
            mappers = (FieldMappers)MapperService.this.indexNameFieldMappers.get(fieldName);
            if (mappers != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().tokenStream(fieldName, reader);
            }
            return this.defaultAnalyzer.tokenStream(fieldName, reader);
        }

        @Override
        public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
            FieldMappers mappers;
            int dotIndex = fieldName.indexOf(46);
            if (dotIndex != -1) {
                String possibleType = fieldName.substring(0, dotIndex);
                DocumentMapper possibleDocMapper = (DocumentMapper)MapperService.this.mappers.get(possibleType);
                if (possibleDocMapper != null) {
                    return possibleDocMapper.mappers().searchAnalyzer().reusableTokenStream(fieldName, reader);
                }
            }
            if ((mappers = (FieldMappers)MapperService.this.fullNameFieldMappers.get(fieldName)) != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().reusableTokenStream(fieldName, reader);
            }
            mappers = (FieldMappers)MapperService.this.indexNameFieldMappers.get(fieldName);
            if (mappers != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer().reusableTokenStream(fieldName, reader);
            }
            return this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
        }
    }

    public static class SmartNameFieldMappers {
        private final FieldMappers fieldMappers;
        private final DocumentMapper docMapper;

        public SmartNameFieldMappers(FieldMappers fieldMappers, @Nullable DocumentMapper docMapper) {
            this.fieldMappers = fieldMappers;
            this.docMapper = docMapper;
        }

        public boolean hasMapper() {
            return !this.fieldMappers.isEmpty();
        }

        public FieldMapper mapper() {
            return this.fieldMappers.mapper();
        }

        public FieldMappers fieldMappers() {
            return this.fieldMappers;
        }

        public boolean hasDocMapper() {
            return this.docMapper != null;
        }

        public DocumentMapper docMapper() {
            return this.docMapper;
        }
    }
}

