/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;

public class IdsQueryBuilder
extends BaseQueryBuilder {
    private String type;
    private List<String> values = new ArrayList<String>();
    private float boost = -1.0f;

    public IdsQueryBuilder(String type) {
        this.type = type;
    }

    public IdsQueryBuilder addIds(String ... ids) {
        this.values.addAll(Arrays.asList(ids));
        return this;
    }

    public IdsQueryBuilder ids(String ... ids) {
        return this.addIds(ids);
    }

    public IdsQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("ids");
        builder.field("type", this.type);
        builder.startArray("values");
        for (String value : this.values) {
            builder.value((Object)value);
        }
        builder.endArray();
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

