/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class SpanNotQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "span_not";

    @Inject
    public SpanNotQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        SpanQuery include = null;
        SpanQuery exclude = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("include".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(this.index, "spanNot [include] must be of type span query");
                    }
                    include = query;
                    continue;
                }
                if (!"exclude".equals(currentFieldName)) continue;
                query = parseContext.parseInnerQuery();
                if (!(query instanceof SpanQuery)) {
                    throw new QueryParsingException(this.index, "spanNot [exclude] must be of type span query");
                }
                exclude = query;
                continue;
            }
            if (!"boost".equals(currentFieldName)) continue;
            boost = parser.floatValue();
        }
        if (include == null) {
            throw new QueryParsingException(this.index, "spanNot must have [include] span query clause");
        }
        if (exclude == null) {
            throw new QueryParsingException(this.index, "spanNot must have [exclude] span query clause");
        }
        query = new SpanNotQuery(include, exclude);
        query.setBoost(boost);
        return query;
    }
}

