/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.bytes.ByteFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.field.data.floats.FloatFieldData;
import org.elasticsearch.index.field.data.ints.IntFieldData;
import org.elasticsearch.index.field.data.longs.LongFieldData;
import org.elasticsearch.index.field.data.shorts.ShortFieldData;

public abstract class NumericRangeFieldDataFilter<T>
extends Filter {
    final FieldDataCache fieldDataCache;
    final String field;
    final T lowerVal;
    final T upperVal;
    final boolean includeLower;
    final boolean includeUpper;

    public String getField() {
        return this.field;
    }

    public T getLowerVal() {
        return this.lowerVal;
    }

    public T getUpperVal() {
        return this.upperVal;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    protected NumericRangeFieldDataFilter(FieldDataCache fieldDataCache, String field, T lowerVal, T upperVal, boolean includeLower, boolean includeUpper) {
        this.fieldDataCache = fieldDataCache;
        this.field = field;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.field).append(":");
        return sb.append(this.includeLower ? (char)'[' : '{').append(this.lowerVal == null ? "*" : this.lowerVal.toString()).append(" TO ").append(this.upperVal == null ? "*" : this.upperVal.toString()).append(this.includeUpper ? (char)']' : '}').toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericRangeFieldDataFilter)) {
            return false;
        }
        NumericRangeFieldDataFilter other = (NumericRangeFieldDataFilter)o;
        if (!this.field.equals(other.field) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        return !(this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null);
    }

    public final int hashCode() {
        int h = this.field.hashCode();
        h ^= this.lowerVal != null ? this.lowerVal.hashCode() : 550356204;
        h = h << 1 | h >>> 31;
        h ^= this.upperVal != null ? this.upperVal.hashCode() : -1674416163;
        return h ^= (this.includeLower ? 1549299360 : -365038026) ^ (this.includeUpper ? 1721088258 : 1948649653);
    }

    public static NumericRangeFieldDataFilter<Byte> newByteRange(FieldDataCache fieldDataCache, String field, Byte lowerVal, Byte upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Byte>(fieldDataCache, field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                byte inclusiveUpperPoint;
                byte inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = ((Byte)this.lowerVal).byteValue();
                    if (!this.includeLower && i == 127) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveLowerPoint = (byte)(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = -128;
                }
                if (this.upperVal != null) {
                    i = ((Byte)this.upperVal).byteValue();
                    if (!this.includeUpper && i == -128) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveUpperPoint = (byte)(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = 127;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocSet.EMPTY_DOC_SET;
                }
                final ByteFieldData fieldData = (ByteFieldData)this.fieldDataCache.cache(FieldDataType.DefaultTypes.BYTE, reader, this.field);
                return new GetDocSet(reader.maxDoc()){

                    @Override
                    public boolean isCacheable() {
                        return false;
                    }

                    @Override
                    public boolean get(int doc) throws IOException {
                        if (!fieldData.hasValue(doc)) {
                            return false;
                        }
                        if (fieldData.multiValued()) {
                            byte[] values;
                            for (byte value : values = fieldData.values(doc)) {
                                if (value < inclusiveLowerPoint || value > inclusiveUpperPoint) continue;
                                return true;
                            }
                            return false;
                        }
                        byte value = fieldData.value(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static NumericRangeFieldDataFilter<Short> newShortRange(FieldDataCache fieldDataCache, String field, Short lowerVal, Short upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Short>(fieldDataCache, field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                short inclusiveUpperPoint;
                short inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = ((Short)this.lowerVal).shortValue();
                    if (!this.includeLower && i == Short.MAX_VALUE) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveLowerPoint = (short)(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = Short.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = ((Short)this.upperVal).shortValue();
                    if (!this.includeUpper && i == Short.MIN_VALUE) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveUpperPoint = (short)(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = Short.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocSet.EMPTY_DOC_SET;
                }
                final ShortFieldData fieldData = (ShortFieldData)this.fieldDataCache.cache(FieldDataType.DefaultTypes.SHORT, reader, this.field);
                return new GetDocSet(reader.maxDoc()){

                    @Override
                    public boolean isCacheable() {
                        return false;
                    }

                    @Override
                    public boolean get(int doc) throws IOException {
                        if (!fieldData.hasValue(doc)) {
                            return false;
                        }
                        if (fieldData.multiValued()) {
                            short[] values;
                            for (short value : values = fieldData.values(doc)) {
                                if (value < inclusiveLowerPoint || value > inclusiveUpperPoint) continue;
                                return true;
                            }
                            return false;
                        }
                        short value = fieldData.value(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static NumericRangeFieldDataFilter<Integer> newIntRange(FieldDataCache fieldDataCache, String field, Integer lowerVal, Integer upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Integer>(fieldDataCache, field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                int inclusiveUpperPoint;
                int inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = (Integer)this.lowerVal;
                    if (!this.includeLower && i == Integer.MAX_VALUE) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1;
                } else {
                    inclusiveLowerPoint = Integer.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = (Integer)this.upperVal;
                    if (!this.includeUpper && i == Integer.MIN_VALUE) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1;
                } else {
                    inclusiveUpperPoint = Integer.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocSet.EMPTY_DOC_SET;
                }
                final IntFieldData fieldData = (IntFieldData)this.fieldDataCache.cache(FieldDataType.DefaultTypes.INT, reader, this.field);
                return new GetDocSet(reader.maxDoc()){

                    @Override
                    public boolean isCacheable() {
                        return false;
                    }

                    @Override
                    public boolean get(int doc) throws IOException {
                        if (!fieldData.hasValue(doc)) {
                            return false;
                        }
                        if (fieldData.multiValued()) {
                            int[] values;
                            for (int value : values = fieldData.values(doc)) {
                                if (value < inclusiveLowerPoint || value > inclusiveUpperPoint) continue;
                                return true;
                            }
                            return false;
                        }
                        int value = fieldData.value(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static NumericRangeFieldDataFilter<Long> newLongRange(FieldDataCache fieldDataCache, String field, Long lowerVal, Long upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Long>(fieldDataCache, field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                long inclusiveUpperPoint;
                long inclusiveLowerPoint;
                long i;
                if (this.lowerVal != null) {
                    i = (Long)this.lowerVal;
                    if (!this.includeLower && i == Long.MAX_VALUE) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1L;
                } else {
                    inclusiveLowerPoint = Long.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = (Long)this.upperVal;
                    if (!this.includeUpper && i == Long.MIN_VALUE) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1L;
                } else {
                    inclusiveUpperPoint = Long.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocSet.EMPTY_DOC_SET;
                }
                final LongFieldData fieldData = (LongFieldData)this.fieldDataCache.cache(FieldDataType.DefaultTypes.LONG, reader, this.field);
                return new GetDocSet(reader.maxDoc()){

                    @Override
                    public boolean isCacheable() {
                        return false;
                    }

                    @Override
                    public boolean get(int doc) throws IOException {
                        if (!fieldData.hasValue(doc)) {
                            return false;
                        }
                        if (fieldData.multiValued()) {
                            long[] values;
                            for (long value : values = fieldData.values(doc)) {
                                if (value < inclusiveLowerPoint || value > inclusiveUpperPoint) continue;
                                return true;
                            }
                            return false;
                        }
                        long value = fieldData.value(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static NumericRangeFieldDataFilter<Float> newFloatRange(FieldDataCache fieldDataCache, String field, Float lowerVal, Float upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Float>(fieldDataCache, field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                float inclusiveUpperPoint;
                float inclusiveLowerPoint;
                int i;
                float f;
                if (this.lowerVal != null) {
                    f = ((Float)this.lowerVal).floatValue();
                    if (!this.includeUpper && f > 0.0f && Float.isInfinite(f)) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    i = NumericUtils.floatToSortableInt(f);
                    inclusiveLowerPoint = NumericUtils.sortableIntToFloat(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = Float.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f = ((Float)this.upperVal).floatValue();
                    if (!this.includeUpper && f < 0.0f && Float.isInfinite(f)) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    i = NumericUtils.floatToSortableInt(f);
                    inclusiveUpperPoint = NumericUtils.sortableIntToFloat(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = Float.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocSet.EMPTY_DOC_SET;
                }
                final FloatFieldData fieldData = (FloatFieldData)this.fieldDataCache.cache(FieldDataType.DefaultTypes.FLOAT, reader, this.field);
                return new GetDocSet(reader.maxDoc()){

                    @Override
                    public boolean isCacheable() {
                        return false;
                    }

                    @Override
                    public boolean get(int doc) throws IOException {
                        if (!fieldData.hasValue(doc)) {
                            return false;
                        }
                        if (fieldData.multiValued()) {
                            float[] values;
                            for (float value : values = fieldData.values(doc)) {
                                if (!(value >= inclusiveLowerPoint) || !(value <= inclusiveUpperPoint)) continue;
                                return true;
                            }
                            return false;
                        }
                        float value = fieldData.value(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static NumericRangeFieldDataFilter<Double> newDoubleRange(FieldDataCache fieldDataCache, String field, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Double>(fieldDataCache, field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                double inclusiveUpperPoint;
                double inclusiveLowerPoint;
                long i;
                double f;
                if (this.lowerVal != null) {
                    f = (Double)this.lowerVal;
                    if (!this.includeUpper && f > 0.0 && Double.isInfinite(f)) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    i = NumericUtils.doubleToSortableLong(f);
                    inclusiveLowerPoint = NumericUtils.sortableLongToDouble(this.includeLower ? i : i + 1L);
                } else {
                    inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f = (Double)this.upperVal;
                    if (!this.includeUpper && f < 0.0 && Double.isInfinite(f)) {
                        return DocSet.EMPTY_DOC_SET;
                    }
                    i = NumericUtils.doubleToSortableLong(f);
                    inclusiveUpperPoint = NumericUtils.sortableLongToDouble(this.includeUpper ? i : i - 1L);
                } else {
                    inclusiveUpperPoint = Double.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocSet.EMPTY_DOC_SET;
                }
                final DoubleFieldData fieldData = (DoubleFieldData)this.fieldDataCache.cache(FieldDataType.DefaultTypes.DOUBLE, reader, this.field);
                return new GetDocSet(reader.maxDoc()){

                    @Override
                    public boolean isCacheable() {
                        return false;
                    }

                    @Override
                    public boolean get(int doc) throws IOException {
                        if (!fieldData.hasValue(doc)) {
                            return false;
                        }
                        if (fieldData.multiValued()) {
                            double[] values;
                            for (double value : values = fieldData.values(doc)) {
                                if (!(value >= inclusiveLowerPoint) || !(value <= inclusiveUpperPoint)) continue;
                                return true;
                            }
                            return false;
                        }
                        double value = fieldData.value(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }
}

