/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.bloom.BloomFilter;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.mapper.Uid;

public class UidFilter
extends Filter {
    private final Term[] uids;
    private final BloomCache bloomCache;

    public UidFilter(String type, List<String> ids, BloomCache bloomCache) {
        this.bloomCache = bloomCache;
        this.uids = new Term[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            this.uids[i] = new Term("_uid", Uid.createUid(type, ids.get(i)));
        }
        Arrays.sort(this.uids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        BloomFilter filter = this.bloomCache.filter(reader, "_uid", true);
        OpenBitSet set = null;
        TermDocs td = null;
        try {
            for (Term uid : this.uids) {
                UnicodeUtil.UTF8Result utf8 = Unicode.fromStringAsUtf8(uid.text());
                if (!filter.isPresent(utf8.result, 0, utf8.length)) continue;
                if (td == null) {
                    td = reader.termDocs();
                }
                td.seek(uid);
                while (td.next()) {
                    if (set == null) {
                        set = new OpenBitSet(reader.maxDoc());
                    }
                    set.fastSet(td.doc());
                }
            }
        }
        finally {
            if (td != null) {
                td.close();
            }
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UidFilter uidFilter = (UidFilter)o;
        return Arrays.equals(this.uids, uidFilter.uids);
    }

    public int hashCode() {
        return this.uids != null ? Arrays.hashCode(this.uids) : 0;
    }
}

