/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.threadpool.ThreadPool;

public class TranslogService
extends AbstractIndexShardComponent {
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final IndexShard indexShard;
    private final Translog translog;
    private int flushThresholdOperations;
    private ByteSizeValue flushThresholdSize;
    private TimeValue flushThresholdPeriod;
    private final TimeValue interval;
    private ScheduledFuture future;
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public TranslogService(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, ThreadPool threadPool, IndexShard indexShard, Translog translog) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexSettingsService = indexSettingsService;
        this.indexShard = indexShard;
        this.translog = translog;
        this.flushThresholdOperations = this.componentSettings.getAsInt("flush_threshold_ops", this.componentSettings.getAsInt("flush_threshold", 5000));
        this.flushThresholdSize = this.componentSettings.getAsBytesSize("flush_threshold_size", new ByteSizeValue(200L, ByteSizeUnit.MB));
        this.flushThresholdPeriod = this.componentSettings.getAsTime("flush_threshold_period", TimeValue.timeValueMinutes(30L));
        this.interval = this.componentSettings.getAsTime("interval", TimeValue.timeValueMillis(5000L));
        this.logger.debug("interval [{}], flush_threshold_ops [{}], flush_threshold_size [{}], flush_threshold_period [{}]", this.interval, this.flushThresholdOperations, this.flushThresholdSize, this.flushThresholdPeriod);
        this.future = threadPool.schedule(this.interval, "same", new TranslogBasedFlush());
        indexSettingsService.addListener(this.applySettings);
    }

    public void close() {
        this.indexSettingsService.removeListener(this.applySettings);
        this.future.cancel(true);
    }

    private class TranslogBasedFlush
    implements Runnable {
        private volatile long lastFlushTime = System.currentTimeMillis();

        private TranslogBasedFlush() {
        }

        @Override
        public void run() {
            if (TranslogService.this.indexShard.state() == IndexShardState.CLOSED) {
                return;
            }
            int currentNumberOfOperations = TranslogService.this.translog.numberOfOperations();
            if (currentNumberOfOperations > TranslogService.this.flushThresholdOperations) {
                TranslogService.this.logger.trace("flushing translog, operations [{}], breached [{}]", currentNumberOfOperations, TranslogService.this.flushThresholdOperations);
                this.asyncFlushAndReschedule();
                return;
            }
            long sizeInBytes = TranslogService.this.translog.translogSizeInBytes();
            if (sizeInBytes > TranslogService.this.flushThresholdSize.bytes()) {
                TranslogService.this.logger.trace("flushing translog, size [{}], breached [{}]", new ByteSizeValue(sizeInBytes), TranslogService.this.flushThresholdSize);
                this.asyncFlushAndReschedule();
                return;
            }
            if (System.currentTimeMillis() - this.lastFlushTime > TranslogService.this.flushThresholdPeriod.millis()) {
                TranslogService.this.logger.trace("flushing translog, last_flush_time [{}], breached [{}]", this.lastFlushTime, TranslogService.this.flushThresholdPeriod);
                this.asyncFlushAndReschedule();
                return;
            }
            TranslogService.this.future = TranslogService.this.threadPool.schedule(TranslogService.this.interval, "same", this);
        }

        private void asyncFlushAndReschedule() {
            TranslogService.this.threadPool.executor("management").execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (TranslogService.this.indexShard.state() == IndexShardState.STARTED) {
                            TranslogService.this.indexShard.flush(new Engine.Flush());
                        }
                    }
                    catch (EngineClosedException e) {
                    }
                    catch (FlushNotAllowedEngineException e) {
                    }
                    catch (Exception e) {
                        TranslogService.this.logger.warn("failed to flush shard on translog threshold", e, new Object[0]);
                    }
                    TranslogBasedFlush.this.lastFlushTime = System.currentTimeMillis();
                    if (TranslogService.this.indexShard.state() != IndexShardState.CLOSED) {
                        TranslogService.this.future = TranslogService.this.threadPool.schedule(TranslogService.this.interval, "same", TranslogBasedFlush.this);
                    }
                }
            });
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue flushThresholdPeriod;
            ByteSizeValue flushThresholdSize;
            int flushThresholdOperations = settings.getAsInt("index.translog.flush_threshold_ops", TranslogService.this.flushThresholdOperations);
            if (flushThresholdOperations != TranslogService.this.flushThresholdOperations) {
                TranslogService.this.logger.info("updating flush_threshold_ops from [{}] to [{}]", TranslogService.this.flushThresholdOperations, flushThresholdOperations);
                TranslogService.this.flushThresholdOperations = flushThresholdOperations;
            }
            if (!(flushThresholdSize = settings.getAsBytesSize("index.translog.flush_threshold_size", TranslogService.this.flushThresholdSize)).equals(TranslogService.this.flushThresholdSize)) {
                TranslogService.this.logger.info("updating flush_threshold_size from [{}] to [{}]", TranslogService.this.flushThresholdSize, flushThresholdSize);
                TranslogService.this.flushThresholdSize = flushThresholdSize;
            }
            if (!(flushThresholdPeriod = settings.getAsTime("index.translog.flush_threshold_period", TranslogService.this.flushThresholdPeriod)).equals(TranslogService.this.flushThresholdPeriod)) {
                TranslogService.this.logger.info("updating flush_threshold_period from [{}] to [{}]", TranslogService.this.flushThresholdPeriod, flushThresholdPeriod);
                TranslogService.this.flushThresholdPeriod = flushThresholdPeriod;
            }
        }
    }
}

