/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.cache.CacheStats;
import org.elasticsearch.index.merge.MergeStats;

public class NodeIndicesStats
implements Streamable,
Serializable,
ToXContent {
    private ByteSizeValue storeSize;
    private long numDocs;
    private CacheStats cacheStats;
    private MergeStats mergeStats;

    NodeIndicesStats() {
    }

    public NodeIndicesStats(ByteSizeValue storeSize, long numDocs, CacheStats cacheStats, MergeStats mergeStats) {
        this.storeSize = storeSize;
        this.numDocs = numDocs;
        this.cacheStats = cacheStats;
        this.mergeStats = mergeStats;
    }

    public ByteSizeValue storeSize() {
        return this.storeSize;
    }

    public ByteSizeValue getStoreSize() {
        return this.storeSize;
    }

    public long numDocs() {
        return this.numDocs;
    }

    public long getNumDocs() {
        return this.numDocs();
    }

    public CacheStats cache() {
        return this.cacheStats;
    }

    public CacheStats getCache() {
        return this.cache();
    }

    public MergeStats merge() {
        return this.mergeStats;
    }

    public MergeStats getMerge() {
        return this.mergeStats;
    }

    public static NodeIndicesStats readIndicesStats(StreamInput in) throws IOException {
        NodeIndicesStats stats = new NodeIndicesStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.storeSize = ByteSizeValue.readBytesSizeValue(in);
        this.numDocs = in.readVLong();
        this.cacheStats = CacheStats.readCacheStats(in);
        this.mergeStats = MergeStats.readMergeStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.storeSize.writeTo(out);
        out.writeVLong(this.numDocs);
        this.cacheStats.writeTo(out);
        this.mergeStats.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.INDICES);
        builder.field(Fields.SIZE, this.storeSize.toString());
        builder.field(Fields.SIZE_IN_BYTES, this.storeSize.bytes());
        builder.startObject(Fields.DOCS);
        builder.field(Fields.NUM_DOCS, this.numDocs);
        builder.endObject();
        this.cacheStats.toXContent(builder, params);
        this.mergeStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString SIZE = new XContentBuilderString("size");
        static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");
        static final XContentBuilderString DOCS = new XContentBuilderString("docs");
        static final XContentBuilderString NUM_DOCS = new XContentBuilderString("num_docs");

        Fields() {
        }
    }
}

