/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.lucene.store.FSDirectory;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.support.AbstractStore;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListShardStoreMetaData
extends TransportNodesOperationAction<Request, NodesStoreFilesMetaData, NodeRequest, NodeStoreFilesMetaData> {
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListShardStoreMetaData(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv) {
        super(settings, clusterName, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
    }

    public ActionFuture<NodesStoreFilesMetaData> list(ShardId shardId, boolean onlyUnallocated, Set<String> nodesIds, @Nullable TimeValue timeout) {
        return this.execute(new Request(shardId, onlyUnallocated, nodesIds).timeout(timeout));
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "/cluster/nodes/indices/shard/store";
    }

    @Override
    protected String transportNodeAction() {
        return "/cluster/nodes/indices/shard/store/node";
    }

    @Override
    protected Request newRequest() {
        return new Request();
    }

    @Override
    protected NodeRequest newNodeRequest() {
        return new NodeRequest();
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request.shardId, request.unallocated);
    }

    @Override
    protected NodeStoreFilesMetaData newNodeResponse() {
        return new NodeStoreFilesMetaData();
    }

    @Override
    protected NodesStoreFilesMetaData newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeStoreFilesMetaData> nodeStoreFilesMetaDatas = Lists.newArrayList();
        ArrayList<FailedNodeException> failures = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (resp instanceof NodeStoreFilesMetaData) {
                nodeStoreFilesMetaDatas.add((NodeStoreFilesMetaData)resp);
                continue;
            }
            if (!(resp instanceof FailedNodeException)) continue;
            failures.add((FailedNodeException)resp);
        }
        return new NodesStoreFilesMetaData(this.clusterName, nodeStoreFilesMetaDatas.toArray(new NodeStoreFilesMetaData[nodeStoreFilesMetaDatas.size()]), failures.toArray(new FailedNodeException[failures.size()]));
    }

    @Override
    protected NodeStoreFilesMetaData nodeOperation(NodeRequest request) throws ElasticSearchException {
        IndexMetaData metaData;
        if (request.unallocated) {
            IndexService indexService = this.indicesService.indexService(request.shardId.index().name());
            if (indexService == null) {
                return new NodeStoreFilesMetaData(this.clusterService.state().nodes().localNode(), null);
            }
            if (!indexService.hasShard(request.shardId.id())) {
                return new NodeStoreFilesMetaData(this.clusterService.state().nodes().localNode(), null);
            }
        }
        if ((metaData = this.clusterService.state().metaData().index(request.shardId.index().name())) == null) {
            return new NodeStoreFilesMetaData(this.clusterService.state().nodes().localNode(), null);
        }
        try {
            return new NodeStoreFilesMetaData(this.clusterService.state().nodes().localNode(), this.listStoreMetaData(request.shardId));
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to list store metadata for shard [" + request.shardId + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFilesMetaData listStoreMetaData(ShardId shardId) throws IOException {
        InternalIndexShard indexShard;
        IndexService indexService = this.indicesService.indexService(shardId.index().name());
        if (indexService != null && (indexShard = (InternalIndexShard)indexService.shard(shardId.id())) != null) {
            return new StoreFilesMetaData(true, shardId, indexShard.store().list());
        }
        IndexMetaData metaData = this.clusterService.state().metaData().index(shardId.index().name());
        if (metaData == null) {
            return new StoreFilesMetaData(false, shardId, ImmutableMap.<String, StoreFileMetaData>of());
        }
        String storeType = metaData.settings().get("index.store.type", "fs");
        if (!storeType.contains("fs")) {
            return new StoreFilesMetaData(false, shardId, ImmutableMap.<String, StoreFileMetaData>of());
        }
        File indexFile = new File(this.nodeEnv.shardLocation(shardId), "index");
        if (!indexFile.exists()) {
            return new StoreFilesMetaData(false, shardId, ImmutableMap.<String, StoreFileMetaData>of());
        }
        HashMap<String, StoreFileMetaData> files = Maps.newHashMap();
        FSDirectory directory = FSDirectory.open(indexFile);
        try {
            Map<String, String> checksums = AbstractStore.readChecksums(directory);
            for (File file : indexFile.listFiles()) {
                if (file.getName().endsWith(".cks") || file.getName().startsWith("_checksums")) continue;
                files.put(file.getName(), new StoreFileMetaData(file.getName(), file.length(), file.lastModified(), checksums.get(file.getName())));
            }
        }
        finally {
            directory.close();
        }
        for (File file : indexFile.listFiles()) {
            byte[] checksumBytes;
            if (file.getName().endsWith(".cks") || file.getName().startsWith("_checksums")) continue;
            String checksum = null;
            File checksumFile = new File(file.getParentFile(), file.getName() + ".cks");
            if (checksumFile.exists() && (checksumBytes = Streams.copyToByteArray(checksumFile)).length > 0) {
                checksum = Unicode.fromBytes(checksumBytes);
            }
            files.put(file.getName(), new StoreFileMetaData(file.getName(), file.length(), file.lastModified(), checksum));
        }
        return new StoreFilesMetaData(false, shardId, files);
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    public static class NodeStoreFilesMetaData
    extends NodeOperationResponse {
        private StoreFilesMetaData storeFilesMetaData;

        NodeStoreFilesMetaData() {
        }

        public NodeStoreFilesMetaData(DiscoveryNode node, StoreFilesMetaData storeFilesMetaData) {
            super(node);
            this.storeFilesMetaData = storeFilesMetaData;
        }

        public StoreFilesMetaData storeFilesMetaData() {
            return this.storeFilesMetaData;
        }

        public static NodeStoreFilesMetaData readListShardStoreNodeOperationResponse(StreamInput in) throws IOException {
            NodeStoreFilesMetaData resp = new NodeStoreFilesMetaData();
            resp.readFrom(in);
            return resp;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.readBoolean()) {
                this.storeFilesMetaData = StoreFilesMetaData.readStoreFilesMetaData(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.storeFilesMetaData == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.storeFilesMetaData.writeTo(out);
            }
        }
    }

    static class NodeRequest
    extends NodeOperationRequest {
        private ShardId shardId;
        private boolean unallocated;

        NodeRequest() {
        }

        NodeRequest(String nodeId, ShardId shardId, boolean unallocated) {
            super(nodeId);
            this.shardId = shardId;
            this.unallocated = unallocated;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
            this.unallocated = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeBoolean(this.unallocated);
        }
    }

    public static class NodesStoreFilesMetaData
    extends NodesOperationResponse<NodeStoreFilesMetaData> {
        private FailedNodeException[] failures;

        NodesStoreFilesMetaData() {
        }

        public NodesStoreFilesMetaData(ClusterName clusterName, NodeStoreFilesMetaData[] nodes, FailedNodeException[] failures) {
            super(clusterName, (NodeOperationResponse[])nodes);
            this.failures = failures;
        }

        public FailedNodeException[] failures() {
            return this.failures;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodes = new NodeStoreFilesMetaData[in.readVInt()];
            for (int i = 0; i < ((NodeStoreFilesMetaData[])this.nodes).length; ++i) {
                ((NodeStoreFilesMetaData[])this.nodes)[i] = NodeStoreFilesMetaData.readListShardStoreNodeOperationResponse(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(((NodeStoreFilesMetaData[])this.nodes).length);
            for (NodeStoreFilesMetaData response : (NodeStoreFilesMetaData[])this.nodes) {
                response.writeTo(out);
            }
        }
    }

    static class Request
    extends NodesOperationRequest {
        private ShardId shardId;
        private boolean unallocated;

        public Request() {
        }

        public Request(ShardId shardId, boolean unallocated, Set<String> nodesIds) {
            super(nodesIds.toArray(new String[nodesIds.size()]));
            this.shardId = shardId;
            this.unallocated = unallocated;
        }

        public Request(ShardId shardId, boolean unallocated, String ... nodesIds) {
            super(nodesIds);
            this.shardId = shardId;
            this.unallocated = unallocated;
        }

        @Override
        public Request timeout(TimeValue timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
            this.unallocated = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeBoolean(this.unallocated);
        }
    }

    public static class StoreFilesMetaData
    implements Iterable<StoreFileMetaData>,
    Streamable {
        private boolean allocated;
        private ShardId shardId;
        private Map<String, StoreFileMetaData> files;

        StoreFilesMetaData() {
        }

        public StoreFilesMetaData(boolean allocated, ShardId shardId, Map<String, StoreFileMetaData> files) {
            this.allocated = allocated;
            this.shardId = shardId;
            this.files = files;
        }

        public boolean allocated() {
            return this.allocated;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public long totalSizeInBytes() {
            long totalSizeInBytes = 0L;
            for (StoreFileMetaData file : this) {
                totalSizeInBytes += file.length();
            }
            return totalSizeInBytes;
        }

        @Override
        public Iterator<StoreFileMetaData> iterator() {
            return this.files.values().iterator();
        }

        public boolean fileExists(String name) {
            return this.files.containsKey(name);
        }

        public StoreFileMetaData file(String name) {
            return this.files.get(name);
        }

        public static StoreFilesMetaData readStoreFilesMetaData(StreamInput in) throws IOException {
            StoreFilesMetaData md = new StoreFilesMetaData();
            md.readFrom(in);
            return md;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.allocated = in.readBoolean();
            this.shardId = ShardId.readShardId(in);
            int size = in.readVInt();
            this.files = Maps.newHashMapWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                StoreFileMetaData md = StoreFileMetaData.readStoreFileMetaData(in);
                this.files.put(md.name(), md);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.allocated);
            this.shardId.writeTo(out);
            out.writeVInt(this.files.size());
            for (StoreFileMetaData md : this.files.values()) {
                md.writeTo(out);
            }
        }
    }
}

