/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight.vectorhighlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.vectorhighlight.SimpleFragmentsBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class SourceSimpleFragmentsBuilder
extends SimpleFragmentsBuilder {
    private final FieldMapper mapper;
    private final SearchContext searchContext;
    public static final Field[] EMPTY_FIELDS = new Field[0];

    public SourceSimpleFragmentsBuilder(FieldMapper mapper, SearchContext searchContext, String[] preTags, String[] postTags) {
        super(preTags, postTags);
        this.mapper = mapper;
        this.searchContext = searchContext;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SearchLookup lookup = this.searchContext.lookup();
        lookup.setNextReader(reader);
        lookup.setNextDocId(docId);
        List<Object> values = lookup.source().getValues(this.mapper.names().fullName());
        if (values.isEmpty()) {
            return EMPTY_FIELDS;
        }
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.mapper.names().indexName(), values.get(i).toString(), Field.Store.NO, Field.Index.ANALYZED);
        }
        return fields;
    }
}

